/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.importer;

import java.util.concurrent.atomic.AtomicStampedReference;
import org.voltdb.OperationMode;

public final class VersionedOperationMode {
    final OperationMode mode;
    final int version;

    VersionedOperationMode(AtomicStampedReference<OperationMode> ref) {
        if (ref == null) {
            throw new IllegalArgumentException("stamped reference is null");
        }
        int[] stamp = new int[]{0};
        this.mode = ref.get(stamp);
        this.version = stamp[0];
    }

    VersionedOperationMode(OperationMode mode, int version) {
        if (mode == null) {
            throw new IllegalArgumentException("operation mode is null");
        }
        if (version < 0) {
            throw new IllegalArgumentException("version is less than 0");
        }
        this.mode = mode;
        this.version = version;
    }

    public OperationMode getMode() {
        return this.mode;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedOperationMode other = (VersionedOperationMode)obj;
        if (this.mode != other.mode) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "VersionedOperationalMode [mode=" + (Object)((Object)this.mode) + ", version=" + this.version + "]";
    }
}

