/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.voltdb.jdbc.JDBC4ClientConnectionPool;
import org.voltdb.jdbc.JDBC4Connection;
import org.voltdb.jdbc.SQLError;

public class Driver
implements java.sql.Driver {
    public static final String JDBC_PROP_FILE_ENV = "VOLTDB_JDBC_PROPERTIES";
    public static final String JDBC_PROP_FILE_PROP = "voltdb.jdbcproperties";
    public static final String DEFAULT_PROP_FILENAME = "voltdb.properties";
    private static final String URL_PREFIX = "jdbc:voltdb:";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;

    static String[] getServersFromURL(String url) {
        String prefix = "jdbc:voltdb://";
        int end = url.length();
        if (url.indexOf("?") > 0) {
            end = url.indexOf("?");
        }
        String servstring = url.substring(prefix.length(), end);
        return servstring.split(",");
    }

    static Map<String, String> getPropsFromURL(String url) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (url.indexOf("?") > 0) {
            String[] props;
            String propstring = url.substring(url.indexOf("?") + 1);
            for (String prop : props = propstring.split("&")) {
                if (prop.indexOf("=") <= 0) continue;
                String[] comps = prop.split("=");
                results.put(comps[0], comps[1]);
            }
        }
        return results;
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (this.acceptsURL(url)) {
            try {
                Properties fileprops = this.tryToFindPropsFile();
                Properties info = (Properties)props.clone();
                String prefix = "jdbc:voltdb://";
                if (!url.startsWith(prefix)) {
                    throw SQLError.get("s1009");
                }
                String[] servers = Driver.getServersFromURL(url);
                Map<String, String> urlprops = Driver.getPropsFromURL(url);
                for (Map.Entry<String, String> e : urlprops.entrySet()) {
                    info.setProperty(e.getKey(), e.getValue());
                }
                Enumeration<?> e = fileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    info.setProperty(key, fileprops.getProperty(key));
                }
                String user = "";
                String password = "";
                boolean heavyweight = false;
                int maxoutstandingtxns = 0;
                Enumeration<?> e2 = info.propertyNames();
                while (e2.hasMoreElements()) {
                    String key = (String)e2.nextElement();
                    String value = info.getProperty(key);
                    if (key.toLowerCase().equals("user")) {
                        user = value;
                        continue;
                    }
                    if (key.toLowerCase().equals("password")) {
                        password = value;
                        continue;
                    }
                    if (key.toLowerCase().equals("heavyweight")) {
                        heavyweight = value.toLowerCase().equals("true") || value.toLowerCase().equals("yes") || value.toLowerCase().equals("1");
                        continue;
                    }
                    if (!key.toLowerCase().equals("maxoutstandingtxns")) continue;
                    maxoutstandingtxns = Integer.parseInt(value);
                }
                return new JDBC4Connection(JDBC4ClientConnectionPool.get(servers, user, password, heavyweight, maxoutstandingtxns), info);
            }
            catch (Exception x) {
                throw SQLError.get(x, "08001");
            }
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.compile("^jdbc:voltdb://.+", 2).matcher(url).matches();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties loginProps) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties tryToFindPropsFile() {
        File propfile;
        Properties fileprops = new Properties();
        String filename = null;
        filename = System.getenv(JDBC_PROP_FILE_ENV);
        if (filename == null) {
            filename = System.getProperty(JDBC_PROP_FILE_PROP);
        }
        if (filename == null) {
            URL pathToJar = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String tmp = null;
            try {
                tmp = new File(pathToJar.toURI()).getParent() + File.separator + DEFAULT_PROP_FILENAME;
            }
            catch (Exception e) {
                tmp = null;
            }
            filename = tmp;
        }
        if (filename != null && (propfile = new File(filename)).exists() && propfile.isFile()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(propfile);
                fileprops.load(in);
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (IOException ioe) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return fileprops;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

