/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.voltdb.client.ClientStats;
import org.voltdb.client.ClientStatsContext;
import org.voltdb.jdbc.IVoltDBConnection;
import org.voltdb.jdbc.JDBC4CallableStatement;
import org.voltdb.jdbc.JDBC4ClientConnection;
import org.voltdb.jdbc.JDBC4ClientConnectionPool;
import org.voltdb.jdbc.JDBC4DatabaseMetaData;
import org.voltdb.jdbc.JDBC4PreparedStatement;
import org.voltdb.jdbc.JDBC4Statement;
import org.voltdb.jdbc.SQLError;

public class JDBC4Connection
implements Connection,
IVoltDBConnection {
    public static final String COMMIT_THROW_EXCEPTION = "jdbc.committhrowexception";
    public static final String ROLLBACK_THROW_EXCEPTION = "jdbc.rollbackthrowexception";
    public static final String QUERYTIMEOUT_UNIT = "jdbc.querytimeout.unit";
    protected final JDBC4ClientConnection NativeConnection;
    protected final String User;
    protected TimeUnit queryTimeOutUnit = TimeUnit.SECONDS;
    private boolean isClosed = false;
    private Properties props;
    private boolean autoCommit = true;

    public JDBC4Connection(JDBC4ClientConnection connection, Properties props) {
        this.NativeConnection = connection;
        this.props = props;
        this.User = this.props.getProperty("user", "");
        if (this.props.getProperty(QUERYTIMEOUT_UNIT, "Seconds").equalsIgnoreCase("milliseconds")) {
            this.queryTimeOutUnit = TimeUnit.MILLISECONDS;
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.get("08003");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.isClosed = true;
            JDBC4ClientConnectionPool.dispose(this.NativeConnection);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.props.getProperty(COMMIT_THROW_EXCEPTION, "true").equalsIgnoreCase("true")) {
            throw SQLError.noSupport();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            return new JDBC4Statement(this);
        }
        catch (Exception x) {
            throw SQLError.get(x);
        }
    }

    private static void checkCreateStatementSupported(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1004 && resultSetType != 1003 || resultSetConcurrency != 1007 || resultSetHoldability != 2) {
            throw SQLError.noSupport();
        }
    }

    private static void checkCreateStatementSupported(int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBC4Connection.checkCreateStatementSupported(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        JDBC4Connection.checkCreateStatementSupported(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        JDBC4Connection.checkCreateStatementSupported(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createStatement();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBC4DatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        return new JDBC4CallableStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1004 && resultSetConcurrency == 1007) {
            return this.prepareCall(sql);
        }
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new JDBC4PreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1004 && resultSetConcurrency == 1007) {
            return this.prepareStatement(sql);
        }
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.props.getProperty(ROLLBACK_THROW_EXCEPTION, "true").equalsIgnoreCase("true")) {
            throw SQLError.noSupport();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!autoCommit && this.props.getProperty(COMMIT_THROW_EXCEPTION, "true").equalsIgnoreCase("true")) {
            throw SQLError.noSupport();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (level == 8) {
            return;
        }
        throw SQLError.noSupport();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.get("s1009", iface.toString());
        }
    }

    @Override
    public ClientStatsContext createStatsContext() {
        return this.NativeConnection.getClientStatsContext();
    }

    @Override
    public void saveStatistics(ClientStats stats, String file) throws IOException {
        this.NativeConnection.saveStatistics(stats, file);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public String getSchema() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw SQLError.noSupport();
    }

    @Override
    public void writeSummaryCSV(ClientStats stats, String path) throws IOException {
        this.NativeConnection.writeSummaryCSV(stats, path);
    }
}

