/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.jdbc.JDBC4Connection;
import org.voltdb.jdbc.JDBC4ResultSet;
import org.voltdb.jdbc.SQLError;

public class JDBC4DatabaseMetaData
implements DatabaseMetaData {
    static final String[] tableTypes = new String[]{"TABLE", "VIEW"};
    private final CallableStatement sysInfo;
    private final CallableStatement sysCatalog;
    private final JDBC4Connection sourceConnection;
    private String buildString = null;
    private String versionString = null;
    private String catalogString = null;

    JDBC4DatabaseMetaData(JDBC4Connection connection) throws SQLException {
        this.sourceConnection = connection;
        this.sysInfo = connection.prepareCall("{call @SystemInformation}");
        this.sysCatalog = connection.prepareCall("{call @SystemCatalog(?)}");
        this.loadSystemInformation();
    }

    private void loadSystemInformation() throws SQLException {
        ResultSet res = this.sysInfo.executeQuery();
        while (res.next()) {
            if (res.getString(2).equals("BUILDSTRING")) {
                this.buildString = res.getString(3);
                continue;
            }
            if (res.getString(2).equals("VERSION")) {
                this.versionString = res.getString(3);
                continue;
            }
            if (!res.getString(2).equals("CATALOG")) continue;
            this.catalogString = res.getString(3);
        }
        res.close();
    }

    private void checkClosed() throws SQLException {
        if (this.sourceConnection.isClosed()) {
            throw SQLError.get("08003");
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.checkClosed();
        VoltTable result = new VoltTable(new VoltTable.ColumnInfo("TABLE_CAT", VoltType.STRING), new VoltTable.ColumnInfo[0]);
        result.addRow(this.catalogString);
        return new JDBC4ResultSet(null, result);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        this.checkClosed();
        return "catalog";
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkClosed();
        this.sysCatalog.setString(1, "COLUMNS");
        JDBC4ResultSet res = (JDBC4ResultSet)this.sysCatalog.executeQuery();
        VoltTable vtable = res.getVoltTable().clone(0);
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        Pattern table_pattern = JDBC4DatabaseMetaData.computeJavaPattern(tableNamePattern);
        if (columnNamePattern == null || columnNamePattern.length() == 0) {
            columnNamePattern = "%";
        }
        Pattern column_pattern = JDBC4DatabaseMetaData.computeJavaPattern(columnNamePattern);
        while (res.next()) {
            Matcher column_matcher;
            Matcher table_matcher = table_pattern.matcher(res.getString("TABLE_NAME"));
            if (!table_matcher.matches() || !(column_matcher = column_pattern.matcher(res.getString("COLUMN_NAME"))).matches()) continue;
            vtable.addRow(res.getRowData());
        }
        return new JDBC4ResultSet(this.sysCatalog, vtable);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.sourceConnection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        this.checkClosed();
        System.out.println("\n\n\nVERSION: " + this.versionString);
        return Integer.valueOf(this.versionString.split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        this.checkClosed();
        return Integer.valueOf(this.versionString.split("\\.")[1]);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        this.checkClosed();
        return "VoltDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.checkClosed();
        return this.buildString;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 8;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    public String getDriverName() throws SQLException {
        this.checkClosed();
        return "voltdb";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        this.checkClosed();
        return new String(this.getDriverMajorVersion() + "." + this.getDriverMinorVersion());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkClosed();
        VoltTable vtable = new VoltTable(new VoltTable.ColumnInfo("PKTABLE_CAT", VoltType.STRING), new VoltTable.ColumnInfo("PKTABLE_SCHEM", VoltType.STRING), new VoltTable.ColumnInfo("PKTABLE_NAME", VoltType.STRING), new VoltTable.ColumnInfo("PKCOLUMN_NAME", VoltType.STRING), new VoltTable.ColumnInfo("FKTABLE_CAT", VoltType.STRING), new VoltTable.ColumnInfo("FKTABLE_SCHEM", VoltType.STRING), new VoltTable.ColumnInfo("FKTABLE_NAME", VoltType.STRING), new VoltTable.ColumnInfo("FKCOLUMN_NAME", VoltType.STRING), new VoltTable.ColumnInfo("KEY_SEQ", VoltType.SMALLINT), new VoltTable.ColumnInfo("UPDATE_RULE", VoltType.SMALLINT), new VoltTable.ColumnInfo("DELETE_RULE", VoltType.SMALLINT), new VoltTable.ColumnInfo("FK_NAME", VoltType.STRING), new VoltTable.ColumnInfo("PK_NAME", VoltType.STRING), new VoltTable.ColumnInfo("DEFERRABILITY", VoltType.SMALLINT));
        JDBC4ResultSet res = new JDBC4ResultSet(this.sysCatalog, vtable);
        return res;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.checkClosed();
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkClosed();
        VoltTable vtable = new VoltTable(new VoltTable.ColumnInfo("PKTABLE_CAT", VoltType.STRING), new VoltTable.ColumnInfo("PKTABLE_SCHEM", VoltType.STRING), new VoltTable.ColumnInfo("PKTABLE_NAME", VoltType.STRING), new VoltTable.ColumnInfo("PKCOLUMN_NAME", VoltType.STRING), new VoltTable.ColumnInfo("FKTABLE_CAT", VoltType.STRING), new VoltTable.ColumnInfo("FKTABLE_SCHEM", VoltType.STRING), new VoltTable.ColumnInfo("FKTABLE_NAME", VoltType.STRING), new VoltTable.ColumnInfo("FKCOLUMN_NAME", VoltType.STRING), new VoltTable.ColumnInfo("KEY_SEQ", VoltType.SMALLINT), new VoltTable.ColumnInfo("UPDATE_RULE", VoltType.SMALLINT), new VoltTable.ColumnInfo("DELETE_RULE", VoltType.SMALLINT), new VoltTable.ColumnInfo("FK_NAME", VoltType.STRING), new VoltTable.ColumnInfo("PK_NAME", VoltType.STRING), new VoltTable.ColumnInfo("DEFERRABILITY", VoltType.SMALLINT));
        JDBC4ResultSet res = new JDBC4ResultSet(this.sysCatalog, vtable);
        return res;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        assert (table != null && !table.isEmpty());
        this.checkClosed();
        this.sysCatalog.setString(1, "INDEXINFO");
        JDBC4ResultSet res = (JDBC4ResultSet)this.sysCatalog.executeQuery();
        VoltTable vtable = res.getVoltTable().clone(0);
        while (res.next()) {
            if (!res.getString("TABLE_NAME").equals(table) || unique && res.getShort("NON_UNIQUE") != 0) continue;
            vtable.addRow(res.getRowData());
        }
        return new JDBC4ResultSet(this.sysCatalog, vtable);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        this.checkClosed();
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        this.checkClosed();
        return 0x100000;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        this.checkClosed();
        return 0x100000;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        this.checkClosed();
        return 0x200000;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.checkClosed();
        return "ABS,BITAND,BITNOT,BITOR,BIT_SHIFT_LEFT,BIT_SHIFT_RIGHT,BITXOR,CEILING,EXP,FLOOR,LN,LOG,POWER,SQRT";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        assert (table != null && !table.isEmpty());
        this.checkClosed();
        this.sysCatalog.setString(1, "PRIMARYKEYS");
        JDBC4ResultSet res = (JDBC4ResultSet)this.sysCatalog.executeQuery();
        VoltTable vtable = res.getVoltTable().clone(0);
        while (res.next()) {
            if (!res.getString("TABLE_NAME").equals(table)) continue;
            vtable.addRow(res.getRowData());
        }
        return new JDBC4ResultSet(this.sysCatalog, vtable);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        assert (procedureNamePattern != null && !procedureNamePattern.isEmpty());
        this.checkClosed();
        this.sysCatalog.setString(1, "PROCEDURECOLUMNS");
        JDBC4ResultSet res = (JDBC4ResultSet)this.sysCatalog.executeQuery();
        VoltTable vtable = res.getVoltTable().clone(0);
        while (res.next()) {
            if (!res.getString("PROCEDURE_NAME").equals(procedureNamePattern) || columnNamePattern != null && !columnNamePattern.equals("%") && !res.getString("COLUMN_NAME").equals(columnNamePattern)) continue;
            vtable.addRow(res.getRowData());
        }
        return new JDBC4ResultSet(this.sysCatalog, vtable);
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (procedureNamePattern != null && !procedureNamePattern.equals("%")) {
            throw new SQLException(String.format("getProcedures('%s','%s','%s') does not support pattern filtering", catalog, schemaPattern, procedureNamePattern));
        }
        this.checkClosed();
        this.sysCatalog.setString(1, "PROCEDURES");
        ResultSet res = this.sysCatalog.executeQuery();
        return res;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.checkClosed();
        VoltTable vtable = new VoltTable(new VoltTable.ColumnInfo("TABLE_SCHEM", VoltType.STRING), new VoltTable.ColumnInfo("TABLE_CATALOG", VoltType.STRING));
        JDBC4ResultSet res = new JDBC4ResultSet(this.sysCatalog, vtable);
        return res;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getSchemas();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.checkClosed();
        return "BIN,COALESCE,CHAR,CHAR_LENGTH,CONCAT,FORMAT_CURRENCY,HEX,INSERT,LCASE,LEFT,LOWER,LTRIM,OCTET_LENGTH,OVERLAY,POSITION,REPEAT,REPLACE,RIGHT,RTRIM,SPACE,SUBSTRING,SUBSTR,TRIM,UCASE,UPPER";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkClosed();
        VoltTable vtable = new VoltTable(new VoltTable.ColumnInfo("TABLE_CAT", VoltType.STRING), new VoltTable.ColumnInfo("TABLE_SCHEM", VoltType.STRING), new VoltTable.ColumnInfo("TABLE_NAME", VoltType.STRING), new VoltTable.ColumnInfo("GRANTOR", VoltType.STRING), new VoltTable.ColumnInfo("GRANTEE", VoltType.STRING), new VoltTable.ColumnInfo("PRIVILEGE", VoltType.STRING), new VoltTable.ColumnInfo("IS_GRANTABLE", VoltType.STRING));
        JDBC4ResultSet res = new JDBC4ResultSet(this.sysCatalog, vtable);
        return res;
    }

    public static Pattern computeJavaPattern(String sqlPattern) {
        StringBuffer pattern_buff = new StringBuffer();
        for (int i = 0; i < sqlPattern.length(); ++i) {
            char c = sqlPattern.charAt(i);
            if (c == '_') {
                pattern_buff.append('.');
                continue;
            }
            if (c == '%') {
                pattern_buff.append(".*");
                continue;
            }
            pattern_buff.append(c);
        }
        return Pattern.compile(pattern_buff.toString());
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.checkClosed();
        this.sysCatalog.setString(1, "TABLES");
        JDBC4ResultSet res = (JDBC4ResultSet)this.sysCatalog.executeQuery();
        VoltTable vtable = res.getVoltTable().clone(0);
        List<String> typeStrings = null;
        if (types != null) {
            typeStrings = Arrays.asList(types);
        }
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        Pattern table_pattern = JDBC4DatabaseMetaData.computeJavaPattern(tableNamePattern);
        while (res.next()) {
            Matcher table_matcher;
            if (typeStrings != null && !typeStrings.contains(res.getString("TABLE_TYPE")) || !(table_matcher = table_pattern.matcher(res.getString("TABLE_NAME"))).matches()) continue;
            vtable.addRow(res.getRowData());
        }
        return new JDBC4ResultSet(this.sysCatalog, vtable);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.checkClosed();
        VoltTable vtable = new VoltTable(new VoltTable.ColumnInfo("TABLE_TYPE", VoltType.STRING), new VoltTable.ColumnInfo[0]);
        for (String type : tableTypes) {
            vtable.addRow(type);
        }
        JDBC4ResultSet res = new JDBC4ResultSet(this.sysCatalog, vtable);
        return res;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.checkClosed();
        return "CURRENT_TIMESTAMP,DAY,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,EXTRACT,FROM_UNIXTIME,HOUR,MINUT,MONTH,NOW,QUARTER,SECOND,SINCE_EPOCH,TO_TIMESTAMP,TRUNCATE,WEEK,WEEKOFYEAR,WEEKDAY,YEAR";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.checkClosed();
        this.sysCatalog.setString(1, "TYPEINFO");
        ResultSet res = this.sysCatalog.executeQuery();
        return res;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public String getURL() throws SQLException {
        this.checkClosed();
        return "http://voltdb.com/";
    }

    @Override
    public String getUserName() throws SQLException {
        this.checkClosed();
        return this.sourceConnection.User;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        this.checkClosed();
        switch (fromType) {
            case -3: 
            case 12: 
            case 93: {
                switch (toType) {
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        this.checkClosed();
        return type == 1004 && concurrency == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        this.checkClosed();
        return type == 1004;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        this.checkClosed();
        return level == 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.get("s1009", iface.toString());
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkClosed();
        throw SQLError.noSupport();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw SQLError.noSupport();
    }
}

