/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.voltdb.VoltType;
import org.voltdb.jdbc.JDBC4ResultSet;
import org.voltdb.jdbc.SQLError;

public class JDBC4ResultSetMetaData
implements ResultSetMetaData {
    private JDBC4ResultSet sourceResultSet;
    private static final String catalogName = "";
    private static final String schemaName = "";
    private static final String tableName = "Resultset";

    public JDBC4ResultSetMetaData(JDBC4ResultSet resultSet) {
        this.sourceResultSet = resultSet;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        String result = type.getJdbcClass();
        if (result == null) {
            throw SQLError.get("42S82", new Object[]{type});
        }
        return result;
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.sourceResultSet.checkClosed();
        return this.sourceResultSet.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        switch (type) {
            case TINYINT: {
                return new Byte(-128).toString().length();
            }
            case SMALLINT: {
                return new Short(Short.MIN_VALUE).toString().length();
            }
            case INTEGER: {
                return new Integer(Integer.MIN_VALUE).toString().length();
            }
            case BIGINT: {
                return new Long(Long.MIN_VALUE).toString().length();
            }
            case FLOAT: {
                return new Double(Double.MIN_VALUE).toString().length();
            }
            case DECIMAL: {
                return 40;
            }
            case TIMESTAMP: {
                return 32;
            }
            case STRING: 
            case VARBINARY: {
                return 128;
            }
        }
        throw SQLError.get("42S82", new Object[]{type});
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return this.sourceResultSet.table.getColumnName(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        return type.getJdbcSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        String result = type.toSQLString().toUpperCase();
        if (result == null) {
            throw SQLError.get("42S82", new Object[]{type});
        }
        return type.toSQLString().toUpperCase();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        Integer result = type.getTypePrecisionAndRadix()[0];
        if (result == null) {
            result = 0;
        }
        return result;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        Integer result = type.getMaximumScale();
        if (result == null) {
            result = 0;
        }
        return result;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        return type.isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return 2;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.sourceResultSet.checkColumnBounds(column);
        VoltType type = this.sourceResultSet.table.getColumnType(column - 1);
        Boolean result = type.isUnsigned();
        if (result == null) {
            return false;
        }
        return result == false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.get("s1009", iface.toString());
        }
    }
}

