/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.voltdb.parser.SQLParser;

public class JDBCParser {
    private static final Pattern PAT_CALL_WITH_PARAMETERS = Pattern.compile("^\\s*\\{\\s*call\\s+([^\\s()]+)\\s*\\(([?,\\s]+)\\)\\s*\\}\\s*$", 2);
    private static final Pattern PAT_CALL_WITHOUT_PARAMETERS = Pattern.compile("^\\s*\\{\\s*call\\s+([^\\s()]+)\\s*\\}\\s*$", 2);
    private static final Pattern PAT_CLEAN_CALL_PARAMETERS = Pattern.compile("[\\s,]+");

    public static ParsedCall parseJDBCCall(String jdbcCall) throws SQLParser.Exception {
        Matcher m = PAT_CALL_WITH_PARAMETERS.matcher(jdbcCall);
        if (m.matches()) {
            String sql = m.group(1);
            int parameterCount = PAT_CLEAN_CALL_PARAMETERS.matcher(m.group(2)).replaceAll("").length();
            return new ParsedCall(sql, parameterCount);
        }
        m = PAT_CALL_WITHOUT_PARAMETERS.matcher(jdbcCall);
        if (m.matches()) {
            return new ParsedCall(m.group(1), 0);
        }
        return null;
    }

    public static class ParsedCall {
        public String sql;
        public int parameterCount;

        ParsedCall(String sql, int parameterCount) {
            this.sql = sql;
            this.parameterCount = parameterCount;
        }
    }
}

