/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.voltdb.parser.SQLParser;
import org.voltdb.parser.SQLPatternFactory;

public class SQLLexer
extends SQLPatternFactory {
    private static final VerbToken[] VERB_TOKENS = new VerbToken[]{new VerbToken("alter", true), new VerbToken("create", true), new VerbToken("drop", true), new VerbToken("export", true), new VerbToken("partition", true), new VerbToken("dr", true), new VerbToken("set", true), new VerbToken("import", false)};
    private static final ObjectToken[] OBJECT_TOKENS = new ObjectToken[]{new ObjectToken("table", true), new ObjectToken("column", true), new ObjectToken("index", true), new ObjectToken("view", false), new ObjectToken("procedure", false), new ObjectToken("role", false)};
    private static final String[] MODIFIER_TOKENS = new String[]{"assumeunique", "unique"};
    static final char BLOCK_DELIMITER_CHAR = '#';
    static final String BLOCK_DELIMITER = "###";
    private static final Pattern PAT_SINGLE_LINE_COMMENT = Pattern.compile("^\\s*--.*$");
    private static final Pattern PAT_STRIP_CSTYLE_COMMENTS = Pattern.compile("/\\*(.|\\n)*?\\*/");
    private static Pattern PAT_ANY_DDL_FIRST_TOKEN = null;
    private static CheckedPattern[] WHITELISTS = null;
    private static CheckedPattern[] BLACKLISTS = null;
    private static final Pattern PAT_TABLE_DDL_PREAMBLE = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.tokenAlternatives("create", "drop")), SQLPatternFactory.SPF.token("table"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName())).compile("PAT_TABLE_DDL_PREAMBLE");
    private static final Pattern PAT_SELECT_STATEMENT_PREAMBLE = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.token("select")).compile("PAT_SELECT_STATEMENT_PREAMBLE");
    private static final int PARENTTYPE_GROUP = 1;
    private static final int PARENTNAME_GROUP = 2;
    private static final int CHILDTYPE_GROUP = 3;
    private static final int CHILDNAME_GROUP = 4;
    private static final Pattern PAT_ALTER_RENAME = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.token("alter"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectTypeName()), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName()), SQLPatternFactory.SPF.optional(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.token("alter"), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectTypeName()), SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.databaseObjectName()))), SQLPatternFactory.SPF.token("rename"), SQLPatternFactory.SPF.token("to")).compile("PAT_ALTER_RENAME");

    public static boolean isComment(String sql) {
        Matcher commentMatcher = PAT_SINGLE_LINE_COMMENT.matcher(sql);
        return commentMatcher.matches();
    }

    public static boolean isBlockDelimiter(char c) {
        return c == '#';
    }

    public static String extractDDLToken(String sql) {
        String ddlToken = null;
        Matcher ddlMatcher = PAT_ANY_DDL_FIRST_TOKEN.matcher(sql);
        if (ddlMatcher.find()) {
            ddlToken = ddlMatcher.group(1).toLowerCase();
        }
        return ddlToken;
    }

    public static String stripComments(String ddl) {
        String[] ddlLines;
        ddl = SQLLexer.removeCStyleComments(ddl);
        StringBuilder sb = new StringBuilder();
        for (String ddlLine : ddlLines = ddl.split("\n")) {
            sb.append(SQLLexer.stripCommentFromLine(ddlLine)).append(' ');
        }
        return sb.toString();
    }

    public static String stripCommentFromLine(String ddlLine) {
        boolean inQuote = false;
        char quoteChar = ' ';
        boolean lastCharWasDash = false;
        int length = ddlLine.length();
        for (int i = 0; i < length; ++i) {
            char c = ddlLine.charAt(i);
            if (inQuote) {
                if (quoteChar != c) continue;
                inQuote = false;
                continue;
            }
            if (c == '-') {
                if (lastCharWasDash) {
                    return ddlLine.substring(0, i - 1);
                }
                lastCharWasDash = true;
                continue;
            }
            lastCharWasDash = false;
            if (c != '\"' && c != '\'') continue;
            inQuote = true;
            quoteChar = c;
        }
        return ddlLine;
    }

    public static String extractDDLTableName(String sql) {
        Matcher matcher = PAT_TABLE_DDL_PREAMBLE.matcher(sql);
        if (matcher.find()) {
            return matcher.group(2).toLowerCase();
        }
        return null;
    }

    public static String checkPermitted(String sql) {
        for (CheckedPattern cp : BLACKLISTS) {
            CheckedPattern.Result result = cp.check(sql);
            if (result.matcher == null) continue;
            return String.format("%s, in statement: %s", result.explanation, sql);
        }
        boolean hadWLMatch = false;
        for (CheckedPattern cp : WHITELISTS) {
            if (!cp.matches(sql)) continue;
            hadWLMatch = true;
            break;
        }
        if (!hadWLMatch) {
            return String.format("AdHoc DDL contains an unsupported statement: %s", sql);
        }
        return null;
    }

    public static List<String> splitStatements(String sql) {
        String statement;
        ArrayList<String> statements = new ArrayList<String>();
        char[] buf = sql.toCharArray();
        Character cQuote = null;
        String sCommentEnd = null;
        int iStart = 0;
        boolean statementIsComment = false;
        boolean inStatement = false;
        int iCur = 0;
        while (iCur < buf.length) {
            if (!inStatement) {
                if (Character.isWhitespace(buf[iCur])) {
                    iStart = ++iCur;
                    continue;
                }
                inStatement = true;
                continue;
            }
            if (sCommentEnd != null) {
                if (iCur >= buf.length - sCommentEnd.length()) {
                    iCur = buf.length;
                    continue;
                }
                if (String.copyValueOf(buf, iCur, sCommentEnd.length()).equals(sCommentEnd)) {
                    iCur += sCommentEnd.length();
                    sCommentEnd = null;
                    if (!statementIsComment) continue;
                    statement = String.copyValueOf(buf, iStart, iCur - iStart).trim();
                    if (!statement.isEmpty()) {
                        statements.add(statement);
                    }
                    iStart = iCur;
                    statementIsComment = false;
                    inStatement = false;
                    continue;
                }
                ++iCur;
                continue;
            }
            if (cQuote != null) {
                if (buf[iCur] == '\\') {
                    iCur += 2;
                    continue;
                }
                if (buf[iCur] == cQuote.charValue()) {
                    if (++iCur >= buf.length) continue;
                    if (buf[iCur] != cQuote.charValue()) {
                        cQuote = null;
                        continue;
                    }
                    ++iCur;
                    continue;
                }
                ++iCur;
                continue;
            }
            if (buf[iCur] == ';') {
                statement = String.copyValueOf(buf, iStart, iCur - iStart).trim();
                if (!statement.isEmpty()) {
                    statements.add(statement);
                }
                iCur = iStart = iCur + 1;
                inStatement = false;
                continue;
            }
            if (buf[iCur] == '\"' || buf[iCur] == '\'') {
                cQuote = Character.valueOf(buf[iCur]);
                ++iCur;
                continue;
            }
            if (iCur <= buf.length - 2) {
                if (buf[iCur] == '-' && buf[iCur + 1] == '-') {
                    sCommentEnd = "\n";
                    if (iCur == iStart) {
                        statementIsComment = true;
                    }
                    iCur += 2;
                    continue;
                }
                if (buf[iCur] == '/' && buf[iCur + 1] == '*') {
                    sCommentEnd = "*/";
                    if (iCur == iStart) {
                        statementIsComment = true;
                    }
                    iCur += 2;
                    continue;
                }
                ++iCur;
                continue;
            }
            ++iCur;
        }
        if (iStart < buf.length && !(statement = String.copyValueOf(buf, iStart, iCur - iStart).trim()).isEmpty()) {
            statements.add(statement);
        }
        return statements;
    }

    public static boolean isSelect(String statement) {
        return PAT_SELECT_STATEMENT_PREAMBLE.matcher(statement).matches();
    }

    private static String removeCStyleComments(String ddl) {
        StringBuilder sb = new StringBuilder();
        for (String part : PAT_STRIP_CSTYLE_COMMENTS.split(ddl)) {
            sb.append(part);
        }
        return sb.toString();
    }

    private static ObjectToken findObjectToken(String objectTypeName) {
        if (objectTypeName != null) {
            for (ObjectToken ot : OBJECT_TOKENS) {
                if (!ot.token.equalsIgnoreCase(objectTypeName)) continue;
                return ot;
            }
        }
        return null;
    }

    static {
        String[] verbsAll = new String[VERB_TOKENS.length];
        for (int i = 0; i < VERB_TOKENS.length; ++i) {
            verbsAll[i] = SQLLexer.VERB_TOKENS[i].token;
        }
        PAT_ANY_DDL_FIRST_TOKEN = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.tokenAlternatives(verbsAll)), SQLPatternFactory.SPF.anyClause()).compile("PAT_ANY_DDL_FIRST_TOKEN");
        WHITELISTS = new CheckedPattern[]{new WhitelistSupportedPreamblePattern(), new CheckedPattern(SQLParser.SET_GLOBAL_PARAM_FOR_WHITELIST){

            @Override
            String explainMatch(Matcher matcher) {
                return null;
            }
        }};
        BLACKLISTS = new CheckedPattern[]{new BlacklistUnsupportedPreamblePattern(), new BlacklistRenamePattern()};
    }

    private static class BlacklistRenamePattern
    extends CheckedPattern {
        BlacklistRenamePattern() {
            super(PAT_ALTER_RENAME);
        }

        private static String getExplanation(String typeName, boolean isParent) {
            assert (typeName != null);
            ObjectToken token = SQLLexer.findObjectToken(typeName);
            if (token == null) {
                return String.format("AdHoc DDL ALTER/RENAME refers to an unknown object type '%s'", typeName);
            }
            if (isParent) {
                return null;
            }
            if (!token.renameable) {
                return String.format("AdHoc DDL ALTER/RENAME is not supported for object type '%s'", typeName);
            }
            return "AdHoc DDL ALTER/RENAME is not yet supported";
        }

        @Override
        String explainMatch(Matcher matcher) {
            String childType;
            String parentType = matcher.group(1);
            String explanation = BlacklistRenamePattern.getExplanation(parentType, (childType = matcher.group(3)) != null);
            if (explanation == null) {
                explanation = BlacklistRenamePattern.getExplanation(childType, false);
            }
            return explanation;
        }
    }

    private static class BlacklistUnsupportedPreamblePattern
    extends CheckedPattern {
        private static Pattern initPattern() {
            int unsupportedVerbCount = 0;
            for (int i = 0; i < VERB_TOKENS.length; ++i) {
                if (VERB_TOKENS[i].supported) continue;
                ++unsupportedVerbCount;
            }
            String[] verbsNotSupported = new String[unsupportedVerbCount];
            unsupportedVerbCount = 0;
            for (int i = 0; i < VERB_TOKENS.length; ++i) {
                if (VERB_TOKENS[i].supported) continue;
                verbsNotSupported[unsupportedVerbCount++] = VERB_TOKENS[i].token;
            }
            Pattern blacklistPattern = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.capture(SQLPatternFactory.SPF.tokenAlternatives(verbsNotSupported))).compile("PAT_BLACKLISTS-PREAMBLES");
            return blacklistPattern;
        }

        BlacklistUnsupportedPreamblePattern() {
            super(BlacklistUnsupportedPreamblePattern.initPattern());
        }

        @Override
        String explainMatch(Matcher matcher) {
            return String.format("Statement is not supported: %s", matcher.group(1).toUpperCase());
        }
    }

    private static class WhitelistSupportedPreamblePattern
    extends CheckedPattern {
        private static Pattern initPattern() {
            String[] secondTokens = new String[OBJECT_TOKENS.length + MODIFIER_TOKENS.length];
            for (int i = 0; i < OBJECT_TOKENS.length; ++i) {
                secondTokens[i] = OBJECT_TOKENS[i].token;
            }
            for (int j = 0; j < MODIFIER_TOKENS.length; ++j) {
                secondTokens[OBJECT_TOKENS.length + j] = MODIFIER_TOKENS[j];
            }
            int supportedVerbCount = 0;
            for (int i = 0; i < VERB_TOKENS.length; ++i) {
                if (!VERB_TOKENS[i].supported) continue;
                ++supportedVerbCount;
            }
            String[] verbsSupported = new String[supportedVerbCount];
            supportedVerbCount = 0;
            for (int i = 0; i < VERB_TOKENS.length; ++i) {
                if (!VERB_TOKENS[i].supported) continue;
                verbsSupported[supportedVerbCount++] = VERB_TOKENS[i].token;
            }
            Pattern whitelistPattern = SQLPatternFactory.SPF.statementLeader(SQLPatternFactory.SPF.clause(SQLPatternFactory.SPF.tokenAlternatives(verbsSupported), SQLPatternFactory.SPF.tokenAlternatives(secondTokens))).compile("PAT_WHITELISTS-PREAMBLES");
            return whitelistPattern;
        }

        WhitelistSupportedPreamblePattern() {
            super(WhitelistSupportedPreamblePattern.initPattern());
        }

        @Override
        String explainMatch(Matcher matcher) {
            return null;
        }
    }

    private static abstract class CheckedPattern {
        Pattern pattern;

        CheckedPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        Result check(String statement) {
            Result result = new Result();
            Matcher matcher = this.pattern.matcher(statement);
            if (matcher.matches()) {
                result.matcher = matcher;
                result.explanation = this.explainMatch(matcher);
            }
            return result;
        }

        boolean matches(String statement) {
            return this.check((String)statement).matcher != null;
        }

        abstract String explainMatch(Matcher var1);

        static class Result {
            Matcher matcher = null;
            String explanation = null;

            Result() {
            }
        }
    }

    private static class ObjectToken {
        final String token;
        final boolean renameable;

        ObjectToken(String token, boolean renameable) {
            this.token = token;
            this.renameable = renameable;
        }
    }

    private static class VerbToken {
        final String token;
        final boolean supported;

        VerbToken(String token, boolean supported) {
            this.token = token;
            this.supported = supported;
        }
    }
}

