/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.parser;

import java.util.regex.Pattern;
import org.voltcore.logging.VoltLogger;
import org.voltdb.parser.SQLPatternFactory;
import org.voltdb.parser.SQLPatternPart;
import org.voltdb.parser.SQLPatternPartString;

public class SQLPatternPartElement
extends SQLPatternPart {
    String m_leader = null;
    String m_trailer = null;
    String m_separator = null;
    private SQLPatternPart[] m_parts;
    String m_captureLabel = null;
    private static final VoltLogger COMPILER_LOG = new VoltLogger("COMPILER");

    SQLPatternPartElement(String[] strs) {
        this.m_parts = new SQLPatternPart[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            this.m_parts[i] = new SQLPatternPartString(strs[i]);
        }
    }

    SQLPatternPartElement(SQLPatternPart ... parts) {
        this.m_parts = parts;
    }

    SQLPatternPartElement(String str) {
        this.m_parts = new SQLPatternPart[]{new SQLPatternPartString(str)};
    }

    @Override
    public String generateExpression(int flagsAdd) {
        boolean outerOptional;
        int flags = this.m_flags | flagsAdd;
        StringBuilder sb = new StringBuilder();
        if (this.m_leader != null) {
            sb.append(this.m_leader);
        }
        boolean captureGroup = (flags & SQLPatternFactory.CAPTURE) != 0;
        boolean explicitNonCaptureGroup = !captureGroup && (flags & SQLPatternFactory.GROUP) != 0;
        boolean optional = (flags & SQLPatternFactory.OPTIONAL) != 0;
        boolean leadingSpace = (flags & SQLPatternFactory.LEADING_SPACE) != 0;
        boolean leadingSpaceToChild = (flags & SQLPatternFactory.ADD_LEADING_SPACE_TO_CHILD) != 0;
        boolean childLeadingSpace = (flags & SQLPatternFactory.CHILD_SPACE_SEPARATOR) != 0 || leadingSpace && leadingSpaceToChild;
        boolean nonCaptureGroup = explicitNonCaptureGroup || optional && (!captureGroup || leadingSpace);
        boolean innerOptional = optional && captureGroup && !nonCaptureGroup;
        boolean bl = outerOptional = optional && nonCaptureGroup;
        if (nonCaptureGroup) {
            sb.append("(?:");
        }
        if (leadingSpace && !leadingSpaceToChild) {
            sb.append("\\s+(?:");
        }
        if (captureGroup) {
            if (this.m_captureLabel != null) {
                sb.append(String.format("(?<%s>", this.m_captureLabel));
            } else {
                sb.append("(");
            }
        }
        for (int i = 0; i < this.m_parts.length; ++i) {
            int flagsAddChild = 0;
            if (i > 0) {
                if (this.m_separator != null) {
                    sb.append(this.m_separator);
                }
                if (childLeadingSpace) {
                    flagsAddChild |= SQLPatternFactory.LEADING_SPACE;
                }
            } else if (childLeadingSpace && leadingSpaceToChild) {
                flagsAddChild |= SQLPatternFactory.LEADING_SPACE;
            }
            sb.append(this.m_parts[i].generateExpression(flagsAddChild));
        }
        if (captureGroup) {
            sb.append(")");
        }
        if (innerOptional) {
            sb.append("?");
        }
        if (leadingSpace && !leadingSpaceToChild) {
            sb.append(")");
        }
        if (nonCaptureGroup) {
            sb.append(")");
        }
        if (outerOptional) {
            sb.append("?");
        }
        if (this.m_trailer != null) {
            sb.append(this.m_trailer);
        }
        return sb.toString();
    }

    @Override
    public void setCaptureLabel(String captureLabel) {
        this.m_captureLabel = captureLabel;
    }

    @Override
    public Pattern compile(String label) {
        int reFlags = 0;
        if ((this.m_flags & SQLPatternFactory.CASE_SENSITIVE) == 0) {
            reFlags |= 2;
        }
        if ((this.m_flags & SQLPatternFactory.IGNORE_NEW_LINE) == 0) {
            reFlags |= 0x20;
        }
        if ((this.m_flags & SQLPatternFactory.SINGLE_LINE) == 0) {
            reFlags |= 8;
        }
        String regex = this.generateExpression(0);
        COMPILER_LOG.debug(String.format("PATTERN: %s: %s", label, regex));
        return Pattern.compile(regex, reFlags);
    }
}

