/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.types;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json_voltpatches.JSONString;

public class TimestampType
implements JSONString,
Comparable<TimestampType> {
    private final Date m_date;
    private final short m_usecs;

    public TimestampType(long timestamp) {
        this.m_usecs = (short)(timestamp % 1000L);
        long millis = (timestamp - (long)this.m_usecs) / 1000L;
        this.m_date = new Date(millis);
    }

    public TimestampType(Date date) {
        this.m_usecs = 0;
        this.m_date = (Date)date.clone();
    }

    private static long microsFromJDBCformat(String param) {
        Timestamp sqlTS = param.length() == 10 ? Timestamp.valueOf(param + " 00:00:00.000") : Timestamp.valueOf(param);
        long timeInMillis = sqlTS.getTime();
        long fractionalSecondsInNanos = sqlTS.getNanos();
        if (fractionalSecondsInNanos % 1000L != 0L) {
            throw new IllegalArgumentException("Can't convert from String to TimestampType with fractional microseconds");
        }
        return timeInMillis * 1000L + fractionalSecondsInNanos % 1000000L / 1000L;
    }

    public static long millisFromJDBCformat(String param) {
        Timestamp sqlTS = Timestamp.valueOf(param);
        long fractionalSecondsInNanos = sqlTS.getNanos();
        if (fractionalSecondsInNanos % 1000000L != 0L) {
            throw new IllegalArgumentException("Can't convert from String to Date with fractional milliseconds");
        }
        return sqlTS.getTime();
    }

    public TimestampType(String param) {
        this(TimestampType.microsFromJDBCformat(param));
    }

    public TimestampType() {
        this.m_usecs = 0;
        this.m_date = new Date();
    }

    public long getTime() {
        long millis = this.m_date.getTime();
        return millis * 1000L + (long)this.m_usecs;
    }

    public short getUSec() {
        return this.m_usecs;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimestampType)) {
            return false;
        }
        TimestampType ts = (TimestampType)o;
        if (!ts.m_date.equals(this.m_date)) {
            return false;
        }
        return ts.m_usecs == this.m_usecs;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date dateToMillis = this.m_date;
        short usecs = this.m_usecs;
        if (usecs < 0) {
            dateToMillis.setTime(dateToMillis.getTime() - 1L);
            usecs = (short)(usecs + 1000);
        }
        assert (usecs >= 0);
        String format = sdf.format(dateToMillis);
        return format + String.format("%03d", usecs);
    }

    public int hashCode() {
        long usec = this.getTime();
        return (int)usec ^ (int)(usec >> 32);
    }

    @Override
    public int compareTo(TimestampType dateval) {
        int comp = this.m_date.compareTo(dateval.m_date);
        if (comp == 0) {
            return this.m_usecs - dateval.m_usecs;
        }
        return comp;
    }

    public Date asApproximateJavaDate() {
        return (Date)this.m_date.clone();
    }

    public Date asExactJavaDate() {
        if (this.m_usecs != 0) {
            throw new RuntimeException("Can't convert to java Date from TimestampType with fractional milliseconds");
        }
        return (Date)this.m_date.clone();
    }

    public java.sql.Date asExactJavaSqlDate() {
        if (this.m_usecs != 0) {
            throw new RuntimeException("Can't convert to sql Date from TimestampType with fractional milliseconds");
        }
        return new java.sql.Date(this.m_date.getTime());
    }

    public Timestamp asJavaTimestamp() {
        Timestamp result = new Timestamp(this.m_date.getTime());
        result.setNanos(result.getNanos() + this.m_usecs * 1000);
        return result;
    }

    @Override
    public String toJSONString() {
        return String.valueOf(this.getTime());
    }
}

