/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.voltdb.VoltType;
import org.voltdb.client.ClientImpl;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.VoltBulkLoader.BulkLoaderFailureCallBack;
import org.voltdb.client.VoltBulkLoader.VoltBulkLoader;
import org.voltdb.utils.BulkLoaderErrorHandler;
import org.voltdb.utils.CSVDataLoader;
import org.voltdb.utils.RowWithMetaData;

public class CSVBulkDataLoader
implements CSVDataLoader {
    private final VoltBulkLoader m_loader;
    private final BulkLoaderErrorHandler m_errHandler;
    private final AtomicLong m_failedInsertCount = new AtomicLong(0L);

    public CSVBulkDataLoader(ClientImpl client, String tableName, int batchSize, boolean upsertMode, BulkLoaderErrorHandler errHandler) throws Exception {
        this.m_loader = client.getNewBulkLoader(tableName, batchSize, upsertMode, new CsvFailureCallback());
        this.m_errHandler = errHandler;
    }

    public CSVBulkDataLoader(ClientImpl client, String tableName, int batchSize, BulkLoaderErrorHandler errHandler) throws Exception {
        this(client, tableName, batchSize, false, errHandler);
    }

    @Override
    public void setFlushInterval(int delay, int seconds) {
        this.m_loader.setFlushInterval(delay, seconds);
    }

    @Override
    public void flush() throws ExecutionException, InterruptedException {
        this.m_loader.flush();
    }

    @Override
    public VoltType[] getColumnTypes() {
        return this.m_loader.getColumnTypes();
    }

    @Override
    public void insertRow(RowWithMetaData metaData, Object[] values) throws InterruptedException {
        this.m_loader.insertRow(metaData, values);
    }

    @Override
    public void close() throws Exception {
        this.m_loader.close();
    }

    @Override
    public long getProcessedRows() {
        return this.m_loader.getCompletedRowCount();
    }

    @Override
    public long getFailedRows() {
        return this.m_failedInsertCount.get();
    }

    public class CsvFailureCallback
    implements BulkLoaderFailureCallBack {
        @Override
        public void failureCallback(Object rowHandle, Object[] fieldList, ClientResponse response) {
            CSVBulkDataLoader.this.m_failedInsertCount.incrementAndGet();
            CSVBulkDataLoader.this.m_errHandler.handleError((RowWithMetaData)rowHandle, response, response.getStatusString());
        }
    }
}

