/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import com.google_voltpatches.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.voltcore.logging.VoltLogger;
import org.voltdb.ClientResponseImpl;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.client.Client;
import org.voltdb.client.ClientImpl;
import org.voltdb.client.ClientResponse;
import org.voltdb.client.NoConnectionsException;
import org.voltdb.client.ProcCallException;
import org.voltdb.client.ProcedureCallback;
import org.voltdb.utils.BulkLoaderErrorHandler;
import org.voltdb.utils.CSVDataLoader;
import org.voltdb.utils.RowWithMetaData;

public class CSVTupleDataLoader
implements CSVDataLoader {
    private static final VoltLogger m_log = new VoltLogger("CSVLOADER");
    private final Client m_client;
    private final String m_insertProcedure;
    private final VoltType[] m_columnTypes;
    private final BulkLoaderErrorHandler m_errHandler;
    final AtomicLong m_processedCount = new AtomicLong(0L);
    final AtomicLong m_failedCount = new AtomicLong(0L);
    final int m_reportEveryNRows = 10000;

    @Override
    public void setFlushInterval(int delay, int seconds) {
    }

    @Override
    public void flush() {
        if (this.m_client != null) {
            try {
                this.m_client.drain();
            }
            catch (NoConnectionsException ex) {
                m_log.info("Failed to flush: " + ex);
            }
            catch (InterruptedException ex) {
                m_log.info("Failed to flush: " + ex);
            }
        }
    }

    public CSVTupleDataLoader(ClientImpl client, String procName, BulkLoaderErrorHandler errHandler) throws IOException, ProcCallException {
        this.m_client = client;
        this.m_insertProcedure = procName;
        this.m_errHandler = errHandler;
        ArrayList<VoltType> typeList = Lists.newArrayList();
        VoltTable procInfo = client.callProcedure("@SystemCatalog", "PROCEDURECOLUMNS").getResults()[0];
        while (procInfo.advanceRow()) {
            if (!this.m_insertProcedure.equalsIgnoreCase(procInfo.getString("PROCEDURE_NAME"))) continue;
            String typeStr = (String)procInfo.get("TYPE_NAME", VoltType.STRING);
            typeList.add(VoltType.typeFromString(typeStr));
        }
        if (typeList.isEmpty()) {
            throw new RuntimeException("No matching insert procedure available");
        }
        this.m_columnTypes = typeList.toArray(new VoltType[0]);
        int sleptTimes = 0;
        while (!client.isHashinatorInitialized() && sleptTimes < 120) {
            try {
                Thread.sleep(500L);
                ++sleptTimes;
            }
            catch (InterruptedException ex) {}
        }
    }

    @Override
    public VoltType[] getColumnTypes() {
        return this.m_columnTypes;
    }

    @Override
    public void insertRow(RowWithMetaData metaData, Object[] values) throws InterruptedException {
        try {
            PartitionSingleExecuteProcedureCallback cbmt = new PartitionSingleExecuteProcedureCallback(metaData);
            if (!this.m_client.callProcedure((ProcedureCallback)cbmt, this.m_insertProcedure, values)) {
                m_log.fatal("Failed to send CSV insert to VoltDB cluster.");
                ClientResponseImpl response = new ClientResponseImpl(-5, new VoltTable[0], "Failed to call procedure.", 0L);
                this.m_errHandler.handleError(metaData, response, "Failed to call procedure.");
            }
        }
        catch (NoConnectionsException ex) {
            ClientResponseImpl response = new ClientResponseImpl(-5, new VoltTable[0], "Failed to call procedure.", 0L);
            this.m_errHandler.handleError(metaData, response, "Failed to call procedure.");
        }
        catch (IOException ex) {
            ClientResponseImpl response = new ClientResponseImpl(-5, new VoltTable[0], "Failed to call procedure.", 0L);
            this.m_errHandler.handleError(metaData, response, "Failed to call procedure.");
        }
        catch (Exception ex) {
            this.m_errHandler.handleError(metaData, null, ex.toString());
        }
    }

    @Override
    public void close() throws InterruptedException, NoConnectionsException {
        this.m_client.drain();
    }

    @Override
    public long getProcessedRows() {
        return this.m_processedCount.get();
    }

    @Override
    public long getFailedRows() {
        return this.m_failedCount.get();
    }

    private class PartitionSingleExecuteProcedureCallback
    implements ProcedureCallback {
        final RowWithMetaData m_csvLine;

        public PartitionSingleExecuteProcedureCallback(RowWithMetaData csvLine) {
            this.m_csvLine = csvLine;
        }

        @Override
        public void clientCallback(ClientResponse response) throws Exception {
            long currentCount;
            byte status = response.getStatus();
            if (status != 1) {
                CSVTupleDataLoader.this.m_failedCount.incrementAndGet();
                CSVTupleDataLoader.this.m_errHandler.handleError(this.m_csvLine, response, response.getStatusString());
            }
            if ((currentCount = CSVTupleDataLoader.this.m_processedCount.incrementAndGet()) % 10000L == 0L) {
                m_log.info("Inserted " + (currentCount - CSVTupleDataLoader.this.m_failedCount.get()) + " rows");
            }
        }
    }
}

