/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.voltdb.common.Constants;
import org.voltdb.utils.Base64;

public class Encoder {
    private static final int caseDiff = 32;

    public static String hexEncode(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            char ch = Character.forDigit(b >> 4 & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            sb.append(ch);
            ch = Character.forDigit(b & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String hexEncode(String string) {
        return Encoder.hexEncode(string.getBytes(Constants.UTF8ENCODING));
    }

    public static byte[] hexDecode(String hexString) {
        byte[] retval = null;
        String errorText = "String is not properly hex-encoded.";
        if (hexString.length() % 2 != 0) {
            throw new RuntimeException("String is not properly hex-encoded.");
        }
        try {
            retval = new byte[hexString.length() / 2];
            for (int i = 0; i < retval.length; ++i) {
                int value = Integer.parseInt(hexString.substring(2 * i, 2 * i + 2), 16);
                retval[i] = (byte)value;
            }
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("String is not properly hex-encoded.");
        }
        return retval;
    }

    public static String hexDecodeToString(String hexString) {
        byte[] decodedValue = Encoder.hexDecode(hexString);
        return new String(decodedValue, Constants.UTF8ENCODING);
    }

    public static boolean isHexEncodedString(String hexString) {
        if (hexString.length() % 2 != 0) {
            return false;
        }
        try {
            for (int i = 0; i < hexString.length(); ++i) {
                int value = Integer.parseInt(hexString.substring(i, i + 1), 16);
                if (value >= 0 && value <= 15) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String compressAndBase64Encode(String string) {
        try {
            byte[] inBytes = string.getBytes(Constants.UTF8ENCODING);
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)((double)string.length() * 0.7));
            DeflaterOutputStream dos = new DeflaterOutputStream(baos);
            dos.write(inBytes);
            dos.close();
            byte[] outBytes = baos.toByteArray();
            return Base64.encodeToString(outBytes, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String compressAndBase64Encode(byte[] bytes) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
            DeflaterOutputStream dos = new DeflaterOutputStream(baos);
            dos.write(bytes);
            dos.close();
            byte[] outBytes = baos.toByteArray();
            return Base64.encodeToString(outBytes, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBase64AndDecompress(String string) {
        if (string.length() == 0) {
            return "";
        }
        byte[] bytes = Encoder.decodeBase64AndDecompressToBytes(string);
        return new String(bytes, Constants.UTF8ENCODING);
    }

    public static byte[] decodeBase64AndDecompressToBytes(String string) {
        byte[] bytes = Base64.decodeFast(string);
        if (string.length() == 0) {
            return new byte[0];
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InflaterInputStream dis = new InflaterInputStream(bais);
        byte[] buffer = new byte[8192];
        int length = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            while ((length = dis.read(buffer)) >= 0) {
                baos.write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static String base64Encode(String string) {
        try {
            byte[] inBytes = string.getBytes(Constants.UTF8ENCODING);
            return Base64.encodeToString(inBytes, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeToString(bytes, false);
    }

    public static byte[] base64Decode(String string) {
        return Base64.decodeFast(string);
    }

    public static String base64DecodeToString(String string) {
        byte[] decodedValue = Encoder.base64Decode(string);
        return new String(decodedValue, Constants.UTF8ENCODING);
    }
}

