/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import java.io.FileDescriptor;
import org.voltcore.logging.VoltLogger;
import sun.misc.SharedSecrets;

public class PosixAdvise {
    private static final VoltLogger hostLog = new VoltLogger("HOST");
    public static final boolean FALLOCATE_SUPPORTED;
    public static final boolean SYNC_FILE_RANGE_SUPPORTED;
    public static final boolean ENABLE_FADVISE_DONTNEED;
    public static final int POSIX_MADV_NORMAL = 0;
    public static final int POSIX_MADV_RANDOM = 1;
    public static final int POSIX_MADV_SEQUENTIAL = 2;
    public static final int POSIX_MADV_WILLNEED = 3;
    public static final int POSIX_MADV_DONTNEED = 4;
    public static final int POSIX_FADV_NORMAL = 0;
    public static final int POSIX_FADV_RANDOM = 1;
    public static final int POSIX_FADV_SEQUENTIAL = 2;
    public static final int POSIX_FADV_WILLNEED = 3;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
    public static final int SYNC_FILE_RANGE_WRITE = 2;
    public static final int SYNC_FILE_RANGE_WAIT_AFTER = 4;
    public static final int SYNC_FILE_RANGE_SYNC = 7;

    public static native long madvise(long var0, long var2, int var4);

    public static native long fadvise(long var0, long var2, long var4, int var6);

    public static long fadvise(FileDescriptor fd, long offset, long size, int advice) {
        if (advice == 4 && !ENABLE_FADVISE_DONTNEED) {
            return 0L;
        }
        long filedescriptor = SharedSecrets.getJavaIOFileDescriptorAccess().get(fd);
        return PosixAdvise.fadvise(filedescriptor, offset, size, advice);
    }

    public static native long fallocate(long var0, long var2, long var4);

    public static long fallocate(FileDescriptor fd, long offset, long size) {
        long filedescriptor = SharedSecrets.getJavaIOFileDescriptorAccess().get(fd);
        return PosixAdvise.fallocate(filedescriptor, offset, size);
    }

    public static native long sync_file_range(long var0, long var2, long var4, int var6);

    public static long sync_file_range(FileDescriptor fd, long offset, long size, int flags) {
        long filedescriptor = SharedSecrets.getJavaIOFileDescriptorAccess().get(fd);
        return PosixAdvise.sync_file_range(filedescriptor, offset, size, flags);
    }

    static {
        SYNC_FILE_RANGE_SUPPORTED = System.getProperty("os.name").equalsIgnoreCase("linux");
        FALLOCATE_SUPPORTED = System.getProperty("os.name").equalsIgnoreCase("linux");
        ENABLE_FADVISE_DONTNEED = Boolean.getBoolean("ENABLE_FADVISE_DONTNEED");
    }
}

