/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.voltdb.PrivateVoltTableFactory;
import org.voltdb.VoltTable;
import org.voltdb.common.Constants;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;

public class SerializationHelper {
    byte[] memoizedStringBytes;
    String memoizedString;

    int getSerializedSize(String value) {
        if (this.memoizedString == value) {
            assert (this.memoizedStringBytes != null);
        } else {
            this.memoizedString = value;
            this.memoizedStringBytes = value.getBytes(Constants.UTF8ENCODING);
        }
        return this.memoizedStringBytes.length + 4;
    }

    void flattenToBuffer(ByteBuffer buf, String value) {
        if (this.memoizedString == value) {
            assert (this.memoizedStringBytes != null);
        } else {
            this.memoizedString = value;
            this.memoizedStringBytes = value.getBytes(Constants.UTF8ENCODING);
        }
        buf.putInt(this.memoizedStringBytes.length);
        buf.put(this.memoizedStringBytes);
    }

    public static String getString(ByteBuffer buf) throws IOException {
        int len = buf.getInt();
        if (len == -1) {
            return null;
        }
        assert (len >= 0);
        if (len < -1) {
            throw new IOException("String length is negative " + len);
        }
        byte[] strbytes = new byte[len];
        buf.get(strbytes);
        return new String(strbytes, Constants.UTF8ENCODING);
    }

    public static byte[] getVarbinary(ByteBuffer buf) throws IOException {
        int len = buf.getInt();
        if (len == -1) {
            return null;
        }
        assert (len >= 0);
        if (len < -1) {
            throw new IOException("Varbinary length is negative " + len);
        }
        byte[] retval = new byte[len];
        buf.get(retval);
        return retval;
    }

    public static BigDecimal getBigDecimal(ByteBuffer buf) {
        return VoltDecimalHelper.deserializeBigDecimal(buf);
    }

    public static Object readArray(Class<?> type, ByteBuffer buf) throws IOException {
        int count;
        int n = count = type == Byte.TYPE ? buf.getInt() : (int)buf.getShort();
        if (count < 0) {
            throw new IOException("Array length is negative " + count);
        }
        if (type == Byte.TYPE) {
            if (count > 0x100000) {
                throw new IOException("Array length is greater then the max of 1 megabyte " + count);
            }
            byte[] retval = new byte[count];
            buf.get(retval);
            return retval;
        }
        if (type == byte[].class) {
            byte[][] retval = new byte[count][];
            for (int i = 0; i < count; ++i) {
                int size = buf.getInt();
                if (size == -1) {
                    retval[i] = null;
                    continue;
                }
                retval[i] = new byte[size];
                buf.get(retval[i]);
            }
            return retval;
        }
        if (type == Short.TYPE) {
            short[] retval = new short[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getShort();
            }
            return retval;
        }
        if (type == Integer.TYPE) {
            int[] retval = new int[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getInt();
            }
            return retval;
        }
        if (type == Long.TYPE) {
            long[] retval = new long[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getLong();
            }
            return retval;
        }
        if (type == Long.class) {
            Long[] retval = new Long[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getLong();
            }
            return retval;
        }
        if (type == String.class) {
            String[] retval = new String[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = SerializationHelper.getString(buf);
            }
            return retval;
        }
        if (type == Double.TYPE) {
            double[] retval = new double[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getDouble();
            }
            return retval;
        }
        if (type == Double.class) {
            Double[] retval = new Double[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = buf.getDouble();
            }
            return retval;
        }
        if (type == TimestampType.class) {
            TimestampType[] retval = new TimestampType[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = new TimestampType(buf.getLong());
            }
            return retval;
        }
        if (type == BigDecimal.class) {
            BigDecimal[] retval = new BigDecimal[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = SerializationHelper.getBigDecimal(buf);
            }
            return retval;
        }
        if (type == VoltTable.class) {
            VoltTable[] retval = new VoltTable[count];
            for (int i = 0; i < count; ++i) {
                retval[i] = PrivateVoltTableFactory.createVoltTableFromSharedBuffer(buf.slice());
                buf.position(buf.position() + retval[i].getSerializedSize());
            }
            return retval;
        }
        throw new RuntimeException("SerializationHelper.readArray called with unhandled type: " + type.getName());
    }

    public static void writeString(String value, ByteBuffer buf) {
        if (value == null) {
            buf.putInt(-1);
            return;
        }
        byte[] strbytes = value.getBytes(Constants.UTF8ENCODING);
        int len = strbytes.length;
        buf.putInt(len);
        buf.put(strbytes);
    }

    public static void writeVarbinary(byte[] bytes, ByteBuffer buf) throws IOException {
        if (bytes == null) {
            buf.putInt(-1);
            return;
        }
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    public static void writeArray(byte[] values, ByteBuffer buf) throws IOException {
        buf.putInt(values.length);
        buf.put(values);
    }

    public static void writeArray(short[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putShort(values[i]);
        }
    }

    public static void writeArray(int[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putInt(values[i]);
        }
    }

    public static void writeArray(long[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putLong(values[i]);
        }
    }

    public static void writeArray(double[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            buf.putDouble(values[i]);
        }
    }

    public static void writeArray(TimestampType[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                buf.putLong(Long.MIN_VALUE);
                continue;
            }
            buf.putLong(values[i].getTime());
        }
    }

    public static void writeArray(BigDecimal[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                VoltDecimalHelper.serializeNull(buf);
                continue;
            }
            VoltDecimalHelper.serializeBigDecimal(values[i], buf);
        }
    }

    public static void writeArray(VoltTable[] values, ByteBuffer buf) throws IOException {
        if (values.length > Short.MAX_VALUE) {
            throw new IOException("Array exceeds maximum length of 32767 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IOException("Array being fastserialized can't contain null values (position " + i + ")");
            }
            values[i].flattenToBuffer(buf);
        }
    }

    public static void writeArray(byte[][] values, ByteBuffer buf) throws IOException {
        if (values.length > 0x100000) {
            throw new IOException("Array exceeds maximum length of 1048576 bytes");
        }
        buf.putShort((short)values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                buf.putInt(-1);
                continue;
            }
            SerializationHelper.writeArray(values[i], buf);
        }
    }
}

