/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;

public abstract class VoltTypeUtil {
    private static final Logger LOG = Logger.getLogger(VoltTypeUtil.class.getName());
    protected static final Random rand = new Random();
    protected static final Long DATE_STOP = System.currentTimeMillis() / 1000L;
    protected static final Long DATE_START = DATE_STOP - 153792000L;
    private static final VoltType[] CAST_ORDER = new VoltType[]{VoltType.STRING, VoltType.FLOAT, VoltType.DECIMAL, VoltType.TIMESTAMP, VoltType.BIGINT};
    public static final String VoltTypeCastErrorMessage = "ERROR: Unable to determine cast type for '%s' and '%s' types";

    public static Object getRandomValue(VoltType type) {
        return VoltTypeUtil.getRandomValue(type, 32, 0.0, rand);
    }

    public static Object getRandomValue(VoltType type, int maxSize) {
        return VoltTypeUtil.getRandomValue(type, maxSize, 0.0, rand);
    }

    public static Object getRandomValue(VoltType type, int maxSize, double nullFraction, Random r) {
        assert (type != null);
        assert (maxSize >= 0);
        assert (nullFraction >= 0.0);
        assert (nullFraction <= 1.0);
        assert (r != null);
        if (r.nextDouble() < nullFraction) {
            return null;
        }
        Object ret = null;
        switch (type) {
            case TINYINT: {
                ret = (byte)Math.abs(r.nextInt() % 128);
                break;
            }
            case SMALLINT: {
                ret = (short)Math.abs(r.nextInt() % 32768);
                break;
            }
            case INTEGER: {
                ret = Math.abs(r.nextInt() % 100000);
                break;
            }
            case BIGINT: {
                ret = (long)Math.abs(r.nextInt() % 100000);
                break;
            }
            case FLOAT: {
                ret = Math.abs(r.nextDouble());
                break;
            }
            case STRING: {
                assert (maxSize > 0);
                int size = r.nextInt(maxSize) + 1;
                char[] str = new char[size];
                for (int ctr = 0; ctr < size; ++ctr) {
                    char data = (char)r.nextInt(128);
                    if (!Character.isLetter(data)) {
                        --ctr;
                        continue;
                    }
                    str[ctr] = data;
                }
                ret = new String(str);
                break;
            }
            case VARBINARY: {
                assert (maxSize > 0);
                int size = r.nextInt(maxSize) + 1;
                byte[] bytestr = new byte[size];
                r.nextBytes(bytestr);
                ret = bytestr;
                break;
            }
            case TIMESTAMP: {
                long timestamp = (long)r.nextInt((int)(DATE_STOP - DATE_START)) + DATE_START;
                ret = new TimestampType(timestamp * 1000L);
                break;
            }
            case DECIMAL: {
                BigDecimal bd = new BigDecimal(r.nextDouble());
                ret = VoltDecimalHelper.setDefaultScale(bd);
                break;
            }
            default: {
                LOG.severe("ERROR: Unable to generate random value for invalid ValueType '" + (Object)((Object)type) + "'");
            }
        }
        return ret;
    }

    public static VoltType determineImplicitCasting(VoltType left, VoltType right) {
        if (left == VoltType.INVALID || right == VoltType.INVALID) {
            throw new VoltTypeException(String.format(VoltTypeCastErrorMessage, new Object[]{left, right}));
        }
        if (left == VoltType.NULL || right == VoltType.NULL) {
            return VoltType.NULL;
        }
        if (left == VoltType.STRING && right != VoltType.STRING || left != VoltType.STRING && right == VoltType.STRING) {
            throw new VoltTypeException(String.format(VoltTypeCastErrorMessage, new Object[]{left, right}));
        }
        if (left.isNumber() && !right.isNumber() || right.isNumber() && !left.isNumber()) {
            throw new VoltTypeException(String.format(VoltTypeCastErrorMessage, new Object[]{left, right}));
        }
        for (VoltType cast_type : CAST_ORDER) {
            if (left != cast_type && right != cast_type) continue;
            return cast_type;
        }
        if (!(left != VoltType.INTEGER && left != VoltType.SMALLINT && left != VoltType.TINYINT || right != VoltType.INTEGER && right != VoltType.SMALLINT && right != VoltType.TINYINT)) {
            return VoltType.BIGINT;
        }
        throw new VoltTypeException("ERROR: Unable to determine cast type for '" + (Object)((Object)left) + "' and '" + (Object)((Object)right) + "' types");
    }

    public static Object getObjectFromString(VoltType type, String value) throws ParseException {
        Object ret = null;
        switch (type) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                ret = Long.valueOf(value);
                break;
            }
            case FLOAT: {
                ret = Double.valueOf(value);
                break;
            }
            case STRING: {
                ret = value;
                break;
            }
            case VARBINARY: 
            case DECIMAL: {
                if (value == null) break;
                throw new RuntimeException("Only NULL default values for DECIMAL and VARBINARY columns are supported right now");
            }
            case TIMESTAMP: {
                try {
                    ret = new TimestampType(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    Date date = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(value);
                    ret = new TimestampType(date.getTime() * 1000L);
                }
                break;
            }
            default: {
                LOG.severe("ERROR: Unable to get object from string for invalid ValueType '" + (Object)((Object)type) + "'");
            }
        }
        return ret;
    }

    public static long getHashableLongFromObject(Object obj) {
        if (obj == null || VoltType.isNullVoltType(obj)) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        throw new RuntimeException(obj + " cannot be casted to a long");
    }

    public static Timestamp getSqlTimestampFromMicrosSinceEpoch(long timestamp) {
        Timestamp result;
        int remaining = (int)(timestamp % 1000000L);
        if (timestamp >= 0L || remaining == 0) {
            result = new Timestamp(timestamp / 1000L);
            result.setNanos(remaining * 1000);
        } else {
            result = new Timestamp((timestamp / 1000000L - 1L) * 1000L);
            result.setNanos((remaining + 1000000) * 1000);
        }
        return result;
    }

    public static VoltType getNumericLiteralType(VoltType vt, String value) {
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return VoltType.DECIMAL;
        }
        return vt;
    }

    public static class Randomizer {
        private final VoltType type;
        private final int maxSize;
        private final double nullFraction;
        private final Set<Object> uniqueValues;
        private final Random rand;

        public Randomizer(VoltType type, int maxSize, double nullFraction, boolean unique, Random rand) {
            this.type = type;
            this.maxSize = maxSize;
            this.nullFraction = nullFraction;
            this.uniqueValues = unique ? new HashSet() : null;
            this.rand = rand;
        }

        public Object getValue() {
            Object value = null;
            while (value == null) {
                value = VoltTypeUtil.getRandomValue(this.type, this.maxSize, this.nullFraction, this.rand);
                if (this.uniqueValues == null || !this.uniqueValues.contains(value)) continue;
                value = null;
            }
            if (this.uniqueValues != null) {
                this.uniqueValues.add(value);
            }
            return value;
        }
    }
}

