/*
 * Copyright (C) 2010 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Static utilities for working with the eight primitive types and {@code void}, and value types for
 * treating them as unsigned.
 *
 * <p>This package is a part of the open-source <a href="http://github.com/google/guava">Guava</a>
 * library.
 * 
 * <p>See the Guava User Guide article on
 * <a href="https://github.com/google/guava/wiki/PrimitivesExplained">primitive utilities</a>.
 *
 * <h2>Contents</h2>
 *
 * <h3>General static utilities</h3>
 *
 * <ul>
 * <li>{@link com.google_voltpatches.common.primitives.Primitives}
 * </ul>
 *
 * <h3>Per-type static utilities</h3>
 *
 * <ul>
 * <li>{@link com.google_voltpatches.common.primitives.Booleans}
 * <li>{@link com.google_voltpatches.common.primitives.Bytes}
 *     <ul>
 *     <li>{@link com.google_voltpatches.common.primitives.SignedBytes}
 *     <li>{@link com.google_voltpatches.common.primitives.UnsignedBytes}
 *     </ul>
 * <li>{@link com.google_voltpatches.common.primitives.Chars}
 * <li>{@link com.google_voltpatches.common.primitives.Doubles}
 * <li>{@link com.google_voltpatches.common.primitives.Floats}
 * <li>{@link com.google_voltpatches.common.primitives.Ints}
 *     <ul>
 *     <li>{@link com.google_voltpatches.common.primitives.UnsignedInts}
 *     </ul>
 * <li>{@link com.google_voltpatches.common.primitives.Longs}
 *     <ul>
 *     <li>{@link com.google_voltpatches.common.primitives.UnsignedLongs}
 *     </ul>
 * <li>{@link com.google_voltpatches.common.primitives.Shorts}
 * </ul>
 *
 * <h3>Value types</h3>
 * <ul>
 * <li>{@link com.google_voltpatches.common.primitives.UnsignedInteger}
 * <li>{@link com.google_voltpatches.common.primitives.UnsignedLong}
 * </ul>
 */
@ParametersAreNonnullByDefault
@CheckReturnValue
package com.google_voltpatches.common.primitives;

import javax.annotation_voltpatches.CheckReturnValue;
import javax.annotation_voltpatches.ParametersAreNonnullByDefault;
