/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="http://github.com/google/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 * <li>{@link com.google_voltpatches.common.base.Ascii}
 * <li>{@link com.google_voltpatches.common.base.CaseFormat}
 * <li>{@link com.google_voltpatches.common.base.CharMatcher}
 * <li>{@link com.google_voltpatches.common.base.Charsets}
 * <li>{@link com.google_voltpatches.common.base.Joiner}
 * <li>{@link com.google_voltpatches.common.base.Splitter}
 * <li>{@link com.google_voltpatches.common.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 * <li>{@link com.google_voltpatches.common.base.Function}, {@link com.google_voltpatches.common.base.Functions}
 * <li>{@link com.google_voltpatches.common.base.Predicate}, {@link com.google_voltpatches.common.base.Predicates}
 * <li>{@link com.google_voltpatches.common.base.Equivalence}
 * <li>{@link com.google_voltpatches.common.base.Converter}
 * <li>{@link com.google_voltpatches.common.base.Supplier}, {@link com.google_voltpatches.common.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 * <li>{@link com.google_voltpatches.common.base.Defaults}
 * <li>{@link com.google_voltpatches.common.base.Enums}
 * <li>{@link com.google_voltpatches.common.base.Objects}
 * <li>{@link com.google_voltpatches.common.base.Optional}
 * <li>{@link com.google_voltpatches.common.base.Preconditions}
 * <li>{@link com.google_voltpatches.common.base.Stopwatch}
 * <li>{@link com.google_voltpatches.common.base.Throwables}
 * </ul>
 *
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package com.google_voltpatches.common.base;

import javax.annotation_voltpatches.CheckReturnValue;
import javax.annotation_voltpatches.ParametersAreNonnullByDefault;
