/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.db.recorder;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.voovan.db.recorder.exception.RecorderException;

public class Query {
    private List<String> resultFields = new ArrayList<String>();
    private Map<String, Operate> queryAndFields = new IdentityHashMap<String, Operate>();
    private Map<String, Operate> queryOrFields = new IdentityHashMap<String, Operate>();
    private Map<String[], Boolean> orderFields = new IdentityHashMap<String[], Boolean>();
    private List<String> customCondictions = new ArrayList<String>();
    private int pageNumber = -1;
    private int pageSize = -1;

    public Query addResult(String fieldName) {
        this.resultFields.add(fieldName);
        return this;
    }

    public Query addAnd(String fieldName, Operate operator) {
        this.queryAndFields.put(fieldName, operator);
        return this;
    }

    public Query AddOr(String fieldName, Operate operator) {
        this.queryOrFields.put(fieldName, operator);
        return this;
    }

    public Query addAnd(String fieldName) {
        this.queryAndFields.put(fieldName, Operate.EQUAL);
        return this;
    }

    public Query AddOr(String fieldName) {
        this.queryOrFields.put(fieldName, Operate.EQUAL);
        return this;
    }

    public Query addCustomCondiction(String customCondiction) {
        this.customCondictions.add(customCondiction);
        return this;
    }

    public Query addOrder(String ... fieldNames) {
        this.orderFields.put(fieldNames, false);
        return this;
    }

    public Query addOrder(Boolean isDesc, String ... fieldNames) {
        this.orderFields.put(fieldNames, isDesc);
        return this;
    }

    public Query page(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        return this;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected List<String> getResultFields() {
        return this.resultFields;
    }

    protected Map<String, Operate> getQueryAndFields() {
        return this.queryAndFields;
    }

    protected Map<String, Operate> getQueryOrFields() {
        return this.queryOrFields;
    }

    public List<String> getCustomCondictions() {
        return this.customCondictions;
    }

    protected Map<String[], Boolean> getOrderFields() {
        return this.orderFields;
    }

    public static String getActualOperate(Operate operate) throws RecorderException {
        switch (operate) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case GREATER: {
                return ">";
            }
            case LESS: {
                return "<";
            }
            case GREATER_EQUAL: {
                return ">=";
            }
            case LESS_EQUAL: {
                return "<=";
            }
            case LIKE: {
                return "like";
            }
            case IN: {
                return "in";
            }
        }
        throw new RecorderException("operate is unknow");
    }

    public static Query newInstance() {
        return new Query();
    }

    public static enum Operate {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        LESS,
        GREATER_EQUAL,
        LESS_EQUAL,
        LIKE,
        IN;

    }
}

