/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.db.recorder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.voovan.db.DataBaseType;
import org.voovan.db.JdbcOperate;
import org.voovan.db.recorder.Query;
import org.voovan.db.recorder.annotation.Field;
import org.voovan.db.recorder.annotation.NotInsert;
import org.voovan.db.recorder.annotation.NotUpdate;
import org.voovan.db.recorder.annotation.PrimaryKey;
import org.voovan.db.recorder.annotation.Table;
import org.voovan.db.recorder.exception.RecorderException;
import org.voovan.tools.TObject;
import org.voovan.tools.TSQL;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSON;
import org.voovan.tools.reflect.TReflect;

public class Recorder {
    private JdbcOperate jdbcOperate;
    private boolean camelToUnderline = true;

    public Recorder(JdbcOperate jdbcOperate) {
        this.jdbcOperate = jdbcOperate;
        this.camelToUnderline = true;
    }

    public Recorder(JdbcOperate jdbcOperate, boolean camelToUnderline) {
        this.jdbcOperate = jdbcOperate;
        this.camelToUnderline = camelToUnderline;
    }

    public <T> List<T> query(String tableName, T obj, Query query) throws RecorderException {
        try {
            return this.jdbcOperate.queryObjectList(this.buildQuerySqlTemplate(tableName, obj, query), obj.getClass(), (Object)obj);
        }
        catch (Exception e) {
            if (e instanceof RecorderException) {
                throw (RecorderException)e;
            }
            throw new RecorderException("Recorder query error: " + JSON.toJSON(obj), e);
        }
    }

    public <T> List<T> query(T obj, Query query) throws RecorderException {
        return this.query(null, obj, query);
    }

    public <T> List<T> query(String tableName, T obj) throws RecorderException {
        return this.query(tableName, obj, null);
    }

    public <T> List<T> query(T obj) throws RecorderException {
        return this.query(null, obj, null);
    }

    public <T> int update(String tableName, T obj, Query query) throws RecorderException {
        try {
            return this.jdbcOperate.update(this.buildUpdateSqlTemplate(tableName, obj, query), (Object)obj);
        }
        catch (Exception e) {
            if (e instanceof RecorderException) {
                throw (RecorderException)e;
            }
            throw new RecorderException("Recorder update error: " + JSON.toJSON(obj), e);
        }
    }

    public <T> int update(T obj, Query query) throws RecorderException {
        return this.update(null, obj, query);
    }

    public <T> int update(String tableName, T obj) throws RecorderException {
        return this.update(tableName, obj, null);
    }

    public <T> int update(T obj) throws RecorderException {
        return this.update(null, obj, null);
    }

    public <T> int delete(String tableName, T obj, Query query) throws RecorderException {
        try {
            return this.jdbcOperate.update(this.buildDeleteSqlTemplate(tableName, obj, query), (Object)obj);
        }
        catch (Exception e) {
            if (e instanceof RecorderException) {
                throw (RecorderException)e;
            }
            throw new RecorderException("Recorder delete error: " + JSON.toJSON(obj), e);
        }
    }

    public <T> int delete(T obj, Query query) throws RecorderException {
        return this.delete(null, obj, query);
    }

    public <T> int delete(String tableName, T obj) throws RecorderException {
        return this.delete(tableName, obj, null);
    }

    public <T> int delete(T obj) throws RecorderException {
        return this.delete(null, obj, null);
    }

    public <T> int insert(String tableName, T obj) throws RecorderException {
        try {
            return this.jdbcOperate.update(this.buildInsertSqlTemplate(tableName, obj), (Object)obj);
        }
        catch (Exception e) {
            if (e instanceof RecorderException) {
                throw (RecorderException)e;
            }
            throw new RecorderException("Recorder insert error: " + JSON.toJSON(obj), e);
        }
    }

    public <T> int insert(T obj) throws RecorderException {
        return this.insert(null, obj);
    }

    public <T> String buildQuerySqlTemplate(String tableName, T obj, Query query) throws RecorderException {
        Table table = obj.getClass().getAnnotation(Table.class);
        if (tableName == null) {
            tableName = this.getTableNameWithDataBase(obj);
        }
        String mainSql = "select ";
        if (query == null || query.getResultFields().size() == 0) {
            mainSql = mainSql + "*";
        } else {
            for (String resultField : query.getResultFields()) {
                try {
                    if (TReflect.findFieldIgnoreCase(obj.getClass(), (String)resultField) == null) continue;
                    mainSql = mainSql + TSQL.wrapSqlField(this.jdbcOperate, TString.camelToUnderline((String)resultField)) + ",";
                }
                catch (ReflectiveOperationException e) {
                    throw new RecorderException("Recorder query result field is failed", e);
                }
            }
        }
        if (mainSql.endsWith(",")) {
            mainSql = TString.removeSuffix((String)mainSql);
        }
        mainSql = TString.assembly((Object[])new Object[]{mainSql, " from ", tableName});
        String whereSql = this.genWhereSql(obj, query);
        String orderSql = "order by ";
        if (query != null) {
            for (Map.Entry<String[], Boolean> entry : query.getOrderFields().entrySet()) {
                for (String orderField : entry.getKey()) {
                    try {
                        if (TReflect.findFieldIgnoreCase(obj.getClass(), (String)orderField) == null) continue;
                        orderSql = orderSql + orderField + ",";
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RecorderException("Recorder query result field is failed", e);
                    }
                }
                if (orderSql.endsWith(",")) {
                    orderSql = TString.removeSuffix((String)orderSql);
                }
                orderSql = orderSql + (entry.getValue() != false ? " desc" : " asc") + ",";
            }
        }
        if (orderSql.equals("order by ")) {
            orderSql = "";
        }
        if (orderSql.endsWith(",")) {
            orderSql = TString.removeSuffix((String)orderSql);
        }
        String resultSql = TString.assembly((Object[])new Object[]{mainSql, " ", whereSql, " ", orderSql});
        if (query != null) {
            try {
                Connection connection = this.jdbcOperate.getConnection();
                DataBaseType dataBaseType = TSQL.getDataBaseType(connection);
                if (dataBaseType.equals((Object)DataBaseType.Mariadb) || dataBaseType.equals((Object)DataBaseType.MySql)) {
                    return this.genMysqlPageSql(resultSql, query);
                }
                if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
                    return this.genOraclePageSql(resultSql, query);
                }
                if (dataBaseType.equals((Object)DataBaseType.Postage)) {
                    return this.genOraclePageSql(resultSql, query);
                }
                return resultSql;
            }
            catch (SQLException e) {
                throw new RecorderException("Recorder builde page failed", e);
            }
        }
        return resultSql;
    }

    public <T> String buildUpdateSqlTemplate(String tableName, T obj, Query query) throws RecorderException {
        String whereSql;
        java.lang.reflect.Field[] fields;
        Table table = obj.getClass().getAnnotation(Table.class);
        if (tableName == null) {
            tableName = this.getTableNameWithDataBase(obj);
        }
        String mainSql = TString.assembly((Object[])new Object[]{"update ", tableName, " set"});
        String setSql = "";
        for (java.lang.reflect.Field field : fields = TReflect.getFields(obj.getClass())) {
            String sqlFieldName = this.getSqlFieldName(this.jdbcOperate, field);
            String fieldName = field.getName();
            try {
                NotUpdate notUpdate;
                Object fieldValue = TReflect.getFieldValue(obj, (String)fieldName);
                if (query == null || query.getResultFields().size() == 0 ? fieldValue == null || field.getAnnotation(PrimaryKey.class) != null || (notUpdate = field.getAnnotation(NotUpdate.class)) != null && (notUpdate.value().equals("ANY_VALUE") || notUpdate.value().equals(fieldValue.toString())) : query != null && query.getResultFields().size() > 0 && !query.getResultFields().contains(fieldName)) {
                    continue;
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            setSql = TString.assembly((Object[])new Object[]{setSql, sqlFieldName, "=::", fieldName, ","});
        }
        if (setSql.endsWith(",")) {
            setSql = TString.removeSuffix((String)setSql);
        }
        if ((whereSql = this.genWhereSql(obj, query)).trim().equals("where 1=1")) {
            throw new RecorderException("Where sql must be have some condiction");
        }
        String resultSql = TString.assembly((Object[])new Object[]{mainSql, " ", setSql, " ", whereSql});
        return resultSql;
    }

    public <T> String buildInsertSqlTemplate(String tableName, T obj) throws RecorderException {
        java.lang.reflect.Field[] fields;
        Table table = obj.getClass().getAnnotation(Table.class);
        if (tableName == null) {
            tableName = this.getTableNameWithDataBase(obj);
        }
        String mainSql = TString.assembly((Object[])new Object[]{"insert into ", tableName});
        String fieldSql = "";
        String fieldValueSql = "";
        for (java.lang.reflect.Field field : fields = TReflect.getFields(obj.getClass())) {
            String sqlFieldName = this.getSqlFieldName(this.jdbcOperate, field);
            String fieldName = field.getName();
            if (field.getAnnotation(NotInsert.class) != null) continue;
            try {
                Object fieldValue = TReflect.getFieldValue(obj, (String)fieldName);
                if (fieldValue == null) {
                    continue;
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            fieldSql = fieldSql + sqlFieldName + ",";
            fieldValueSql = TString.assembly((Object[])new Object[]{fieldValueSql, "::", fieldName, ","});
        }
        String resultSql = TString.assembly((Object[])new Object[]{mainSql, " (", TString.removeSuffix((String)fieldSql), ") ", "values (", TString.removeSuffix((String)fieldValueSql), ") "});
        return resultSql;
    }

    public <T> String buildDeleteSqlTemplate(String tableName, T obj, Query query) throws RecorderException {
        Table table = obj.getClass().getAnnotation(Table.class);
        if (tableName == null) {
            tableName = this.getTableNameWithDataBase(obj);
        }
        String mainSql = TString.assembly((Object[])new Object[]{"delete from ", tableName});
        String whereSql = this.genWhereSql(obj, query);
        String resultSql = TString.assembly((Object[])new Object[]{mainSql, " ", whereSql});
        return resultSql;
    }

    public String genMysqlPageSql(String sql, Query query) {
        if (query.getPageSize() < 0 || query.getPageNumber() < 0) {
            return sql;
        }
        return TSQL.genMysqlPageSql(sql, query.getPageNumber(), query.getPageSize());
    }

    public String genPostagePageSql(String sql, Query query) {
        if (query.getPageSize() < 0 || query.getPageNumber() < 0) {
            return sql;
        }
        return TSQL.genPostagePageSql(sql, query.getPageNumber(), query.getPageSize());
    }

    public String genOraclePageSql(String sql, Query query) {
        if (query.getPageSize() < 0 || query.getPageNumber() < 0) {
            return sql;
        }
        return TSQL.genOraclePageSql(sql, query.getPageNumber(), query.getPageSize());
    }

    public String genWhereSql(Object obj, Query query) throws RecorderException {
        String whereSql = "where 1=1";
        if (query == null) {
            java.lang.reflect.Field[] fields;
            for (java.lang.reflect.Field field : fields = TReflect.getFields(obj.getClass())) {
                String sqlFieldName = this.getSqlFieldName(this.jdbcOperate, field);
                String fieldName = field.getName();
                if (field.getAnnotation(PrimaryKey.class) == null) continue;
                whereSql = TString.assembly((Object[])new Object[]{whereSql, " and ", sqlFieldName, " =::", fieldName});
                break;
            }
        } else {
            String sqlField;
            for (Map.Entry<String, Query.Operate> entry : query.getQueryAndFields().entrySet()) {
                try {
                    if (TReflect.findFieldIgnoreCase(obj.getClass(), (String)entry.getKey()) == null) continue;
                    sqlField = entry.getKey();
                    if (this.camelToUnderline) {
                        sqlField = TString.camelToUnderline((String)sqlField);
                    }
                    whereSql = TString.assembly((Object[])new Object[]{whereSql, " and ", sqlField, Query.getActualOperate(entry.getValue()), "::", entry.getKey()});
                }
                catch (ReflectiveOperationException e) {
                    throw new RecorderException("Recorder query result field is failed", e);
                }
            }
            for (Map.Entry<String, Query.Operate> entry : query.getQueryOrFields().entrySet()) {
                try {
                    if (TReflect.findFieldIgnoreCase(obj.getClass(), (String)entry.getKey()) == null) continue;
                    sqlField = entry.getKey();
                    if (this.camelToUnderline) {
                        sqlField = TString.camelToUnderline((String)sqlField);
                    }
                    whereSql = TString.assembly((Object[])new Object[]{whereSql, " or ", sqlField, Query.getActualOperate(entry.getValue()), "::", entry.getKey()});
                }
                catch (ReflectiveOperationException e) {
                    throw new RecorderException("Recorder query result field is failed", e);
                }
            }
            if (whereSql.endsWith("or ") || whereSql.endsWith("and ")) {
                int index = whereSql.trim().lastIndexOf(" ");
                whereSql = whereSql.substring(0, index);
            }
            for (String customCondiction : query.getCustomCondictions()) {
                whereSql = TString.assembly((Object[])new Object[]{whereSql, " ", customCondiction});
            }
        }
        return whereSql;
    }

    public <T> String getSqlDatabase(T obj) {
        Table tableAnnotation = obj.getClass().getAnnotation(Table.class);
        if (tableAnnotation == null) {
            return "";
        }
        String databaseName = tableAnnotation.database().equals("") ? "" : tableAnnotation.database() + ".";
        return databaseName;
    }

    public <T> String getSqlTableName(T obj) {
        Table tableAnnotation = obj.getClass().getAnnotation(Table.class);
        String tableName = "";
        tableName = tableAnnotation == null ? obj.getClass().getSimpleName() : (!tableAnnotation.name().equals("") ? tableAnnotation.name() : (!tableAnnotation.value().equals("") ? tableAnnotation.value() : obj.getClass().getSimpleName()));
        if (this.camelToUnderline) {
            tableName = TString.camelToUnderline((String)tableName);
        }
        if (tableAnnotation != null) {
            if (tableAnnotation.lowerCase() == 1) {
                tableName = tableName.toLowerCase();
            } else if (tableAnnotation.upperCase() == 1) {
                tableName = tableName.toUpperCase();
            }
        }
        return tableName;
    }

    public String getTableNameWithDataBase(Object obj) {
        String databaseName = this.getSqlDatabase(obj);
        String tableName = this.getSqlTableName(obj);
        return databaseName + tableName;
    }

    public String getSqlFieldName(JdbcOperate jdbcOperate, java.lang.reflect.Field field) {
        String fieldName = "";
        Field fieldAnnotation = field.getAnnotation(Field.class);
        fieldName = fieldAnnotation == null ? field.getName() : (!fieldAnnotation.name().equals("") ? fieldAnnotation.name() : (!fieldAnnotation.value().equals("") ? fieldAnnotation.value() : field.getName()));
        if (this.camelToUnderline) {
            fieldName = TString.camelToUnderline((String)fieldName);
        }
        if (fieldAnnotation != null) {
            if (fieldAnnotation.lowerCase() == 1) {
                fieldName = fieldName.toLowerCase();
            } else if (fieldAnnotation.upperCase() == 1) {
                fieldName = fieldName.toUpperCase();
            }
        }
        return TSQL.wrapSqlField(jdbcOperate, fieldName);
    }

    public static <R> R buildUpdateBaseObject(R data, String ... updateFilds) throws ReflectiveOperationException {
        java.lang.reflect.Field[] fields;
        List updateFieldList = TObject.asList((Object[])updateFilds);
        for (java.lang.reflect.Field field : fields = TReflect.getFields(data.getClass())) {
            if (field.getAnnotation(PrimaryKey.class) != null || updateFieldList.contains(field.getName())) continue;
            TReflect.setFieldValue(data, (String)field.getName(), null);
        }
        return null;
    }
}

