/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.voovan.db.CallType;
import org.voovan.db.DataBaseType;
import org.voovan.db.JdbcOperate;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class TSQL {
    private static String EQUAL_CONDICTION = " 1=1";
    private static String NOT_EQUAL_CONDICTION = " 1!=1";

    public static List<String> getSqlParamNames(String sqlStr) {
        String[] params = TString.searchByRegex((String)sqlStr, (String)"::\\w+\\b");
        ArrayList<String> sqlParamNames = new ArrayList<String>();
        for (String param : params) {
            sqlParamNames.add(param);
        }
        return sqlParamNames;
    }

    public static String preparedSql(String sqlStr) {
        return TString.fastReplaceAll((String)sqlStr, (String)"::\\w+\\b", (String)"?");
    }

    public static void setPreparedParams(PreparedStatement preparedStatement, List<String> sqlParamNames, Map<String, ?> params) throws SQLException {
        for (int i = 0; i < sqlParamNames.size(); ++i) {
            String paramName = sqlParamNames.get(i);
            Object data = params.get(paramName = paramName.substring(2, paramName.length()));
            if (data == null) {
                preparedStatement.setObject(i + 1, null);
                continue;
            }
            if (TReflect.isBasicType(data.getClass())) {
                preparedStatement.setObject(i + 1, params.get(paramName));
                continue;
            }
            preparedStatement.setObject(i + 1, JSON.toJSON(params.get(paramName)));
        }
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String sqlStr, Map<String, Object> params) throws SQLException {
        sqlStr = TSQL.removeEmptyCondiction(sqlStr, params);
        List<String> sqlParamNames = TSQL.getSqlParamNames(sqlStr);
        if (Logger.isLogLevel((String)"DEBUG")) {
            Logger.fremawork((Object)("[SQL_Executed]: " + TSQL.assembleSQLWithMap(sqlStr, params)));
        }
        String preparedSql = TSQL.preparedSql(sqlStr);
        PreparedStatement preparedStatement = conn.prepareStatement(preparedSql);
        if (params == null) {
            params = new Hashtable<String, Object>();
        }
        TSQL.setPreparedParams(preparedStatement, sqlParamNames, params);
        return preparedStatement;
    }

    public static CallableStatement createCallableStatement(Connection conn, String sqlStr, Map<String, Object> params, CallType[] callTypes) throws SQLException {
        Logger.fremawork((Object)("[SQL_Executed]: " + sqlStr));
        List<String> sqlParamNames = TSQL.getSqlParamNames(sqlStr);
        String preparedSql = TSQL.preparedSql(sqlStr);
        CallableStatement callableStatement = conn.prepareCall(preparedSql);
        if (params == null) {
            params = new Hashtable<String, Object>();
        }
        TSQL.setPreparedParams(callableStatement, sqlParamNames, params);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        for (int i = 0; i < parameterMetaData.getParameterCount(); ++i) {
            int paramMode = parameterMetaData.getParameterMode(i + 1);
            if (paramMode != 4 && paramMode != 2) continue;
            callableStatement.registerOutParameter(i + 1, parameterMetaData.getParameterType(i + 1));
        }
        return callableStatement;
    }

    public static List<Object> getCallableStatementResult(CallableStatement callableStatement) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        for (int i = 0; i < parameterMetaData.getParameterCount(); ++i) {
            int paramMode = parameterMetaData.getParameterMode(i + 1);
            if (paramMode != 4 && paramMode != 2) continue;
            String methodName = TSQL.getDataMethod(parameterMetaData.getParameterType(i + 1));
            try {
                Method method = TReflect.findMethod(CallableStatement.class, (String)methodName, (Class[])new Class[]{Integer.TYPE});
                Object value = TReflect.invokeMethod((Object)callableStatement, (Method)method, (Object[])new Object[]{i + 1});
                result.add(value);
                continue;
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String assembleSQLWithArray(String sqlStr, Object[] args) {
        Map argMap = TObject.arrayToMap((Object[])args);
        return TSQL.assembleSQLWithMap(sqlStr, argMap);
    }

    public static String assembleSQLWithObject(String sqlStr, Object argObjectj) throws ReflectiveOperationException {
        Map argMap = TReflect.getMapfromObject((Object)argObjectj);
        return TSQL.assembleSQLWithMap(sqlStr, argMap);
    }

    public static String assembleSQLWithMap(String sqlStr, Map<String, Object> argMap) {
        if (argMap != null) {
            for (Map.Entry<String, Object> arg : argMap.entrySet()) {
                sqlStr = TString.fastReplaceAll((String)(sqlStr + " "), (String)("::" + arg.getKey() + "\\b"), (String)(TSQL.getSQLString(argMap.get(arg.getKey())) + " "));
            }
        }
        return sqlStr.trim();
    }

    public static Map<String, Object> getOneRowWithMap(ResultSet resultset) throws SQLException, ReflectiveOperationException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int columnCount = resultset.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            columns.put(resultset.getMetaData().getColumnLabel(i), resultset.getMetaData().getColumnType(i));
        }
        for (Map.Entry columnEntry : columns.entrySet()) {
            String methodName = TSQL.getDataMethod((Integer)columnEntry.getValue());
            Object value = TReflect.invokeMethod((Object)resultset, (String)methodName, (Object[])new Object[]{columnEntry.getKey()});
            resultMap.put((String)columnEntry.getKey(), value);
        }
        return resultMap;
    }

    public static Object getOneRowWithObject(Class<?> clazz, ResultSet resultset) throws SQLException, ReflectiveOperationException, ParseException {
        Map<String, Object> rowMap = TSQL.getOneRowWithMap(resultset);
        return TReflect.getObjectFromMap(clazz, rowMap, (boolean)true);
    }

    public static List<Map<String, Object>> getAllRowWithMapList(ResultSet resultSet) throws SQLException, ReflectiveOperationException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        while (resultSet != null && resultSet.next()) {
            resultList.add(TSQL.getOneRowWithMap(resultSet));
        }
        return resultList;
    }

    public static List<Object> getAllRowWithObjectList(Class<?> clazz, ResultSet resultSet) throws SQLException, ReflectiveOperationException, ParseException {
        ArrayList<Object> resultList = new ArrayList<Object>();
        while (resultSet != null && resultSet.next()) {
            resultList.add(TSQL.getOneRowWithObject(clazz, resultSet));
        }
        return resultList;
    }

    public static String removeEmptyCondiction(String sqlText, Map<String, Object> params) {
        if (params == null) {
            params = new Hashtable<String, Object>();
        }
        List<String[]> condictionList = TSQL.parseSQLCondiction(sqlText);
        for (String[] condictionArr : condictionList) {
            String[] condictions;
            String orginCondiction = condictionArr[0];
            String beforeCondictionMethod = condictionArr[1];
            String condictionName = condictionArr[2];
            String operatorChar = condictionArr[3];
            String originCondictionParams = condictionArr[4];
            String afterCondictionMethod = condictionArr[5];
            String replaceCondiction = orginCondiction;
            String condictionParams = originCondictionParams;
            if (originCondictionParams == null || !originCondictionParams.contains("::") || (condictions = TString.searchByRegex((String)originCondictionParams, (String)"::\\w+\\b")).length <= 0) continue;
            for (String condictionParam : condictions) {
                if (params.containsKey(condictionParam.replace("::", ""))) continue;
                if (operatorChar.equals("in") || operatorChar.equals("not in")) {
                    condictionParams = TString.fastReplaceAll((String)condictionParams, (String)(condictionParam + "\\s*,?"), (String)"");
                    continue;
                }
                replaceCondiction = EQUAL_CONDICTION;
                if ("or".equals(beforeCondictionMethod) || "or".equals(afterCondictionMethod)) {
                    replaceCondiction = NOT_EQUAL_CONDICTION;
                }
                String targetCondiction = condictionName + "\\s*" + operatorChar + "\\s*" + originCondictionParams;
                targetCondiction = targetCondiction.replaceAll("\\(", "\\\\(");
                targetCondiction = targetCondiction.replaceAll("\\)", "\\\\)");
                targetCondiction = targetCondiction.replaceAll("\\[", "\\\\[");
                targetCondiction = targetCondiction.replaceAll("\\]", "\\\\]");
                targetCondiction = targetCondiction.replaceAll("\\+", "\\\\+");
                replaceCondiction = TString.fastReplaceAll((String)orginCondiction, (String)targetCondiction, (String)replaceCondiction);
            }
            if (operatorChar.equals("in") || operatorChar.equals("not in")) {
                if ((condictionParams = condictionParams.trim()).endsWith(",")) {
                    condictionParams = TString.removeSuffix((String)condictionParams);
                }
                originCondictionParams = originCondictionParams.replaceAll("\\(", "\\\\(");
                originCondictionParams = originCondictionParams.replaceAll("\\)", "\\\\)");
                originCondictionParams = originCondictionParams.replaceAll("\\[", "\\\\[");
                originCondictionParams = originCondictionParams.replaceAll("\\]", "\\\\]");
                originCondictionParams = originCondictionParams.replaceAll("\\+", "\\\\+");
                replaceCondiction = TString.fastReplaceAll((String)replaceCondiction, (String)originCondictionParams, (String)condictionParams);
            }
            sqlText = sqlText.replace(orginCondiction, replaceCondiction);
        }
        return sqlText;
    }

    public static List<String[]> parseSQLCondiction(String sqlText) {
        int i;
        ArrayList<String[]> condictionList = new ArrayList<String[]>();
        String sqlRegx = "((\\swhere\\s)|(\\sand\\s)|(\\sor\\s))[\\S\\s]+?(?=(\\swhere\\s)|(\\sand\\s)|(\\sor\\s)|(\\sgroup by\\s)|(\\sorder\\s)|(\\slimit\\s)|$)";
        String[] sqlCondictions = TString.searchByRegex((String)sqlText, (String)sqlRegx, (Integer)2);
        for (i = 0; i < sqlCondictions.length; ++i) {
            int indexClosePair;
            String condiction = sqlCondictions[i];
            if (TString.regexMatch((String)condiction, (String)"\\(") < TString.regexMatch((String)condiction, (String)"\\)") && TString.searchByRegex((String)condiction, (String)"[\\\"`'].*?\\).*?[\\\"`']").length == 0 && (indexClosePair = condiction.lastIndexOf(")")) != -1) {
                condiction = condiction.substring(0, indexClosePair + 1);
            }
            if (TString.regexMatch((String)condiction, (String)"\\sbetween\\s") > 0) {
                condiction = condiction + sqlCondictions[++i];
            }
            String originCondiction = condiction;
            condiction = condiction.trim();
            String concateMethod = condiction.substring(0, condiction.indexOf(" ") + 1).trim();
            String[] splitedCondicction = TString.searchByRegex((String)(condiction = condiction.substring(condiction.indexOf(" ") + 1, condiction.length()).trim()), (String)"(\\sbetween\\s+)|(\\sis\\s+)|(\\slike\\s+)|(\\s(not\\s)?in\\s+)|(\\!=)|(>=)|(<=)|[=<>]");
            if (splitedCondicction.length == 1) {
                String operatorChar = splitedCondicction[0].trim();
                String[] condictionArr = condiction.split("(\\sbetween\\s+)|(\\sis\\s+)|(\\slike\\s+)|(\\s(not\\s)?in\\s+)|(\\!=)|(>=)|(<=)|[=<>]");
                condictionArr[0] = condictionArr[0].trim();
                if (TString.regexMatch((String)condiction, (String)"\\(") > TString.regexMatch((String)condiction, (String)"\\)") && condictionArr[0].startsWith("(")) {
                    condictionArr[0] = TString.removePrefix((String)condictionArr[0]);
                }
                condictionArr[1] = condictionArr[1].trim();
                if (condictionArr.length > 1) {
                    if (operatorChar.contains("in") && condictionArr[1].trim().startsWith("(") && condictionArr[1].trim().endsWith(")")) {
                        condictionArr[1] = condictionArr[1].substring(1, condictionArr[1].length() - 1);
                    }
                    if (condictionArr[0].startsWith("(") && TString.regexMatch((String)condictionArr[1], (String)"\\(") > TString.regexMatch((String)condictionArr[1], (String)"\\)")) {
                        condictionArr[0] = TString.removePrefix((String)condictionArr[0]);
                    }
                    if (condictionArr[1].endsWith(")") && TString.regexMatch((String)condictionArr[1], (String)"\\(") < TString.regexMatch((String)condictionArr[1], (String)"\\)")) {
                        condictionArr[1] = TString.removeSuffix((String)condictionArr[1]);
                    }
                    condictionList.add(new String[]{originCondiction.trim(), concateMethod, condictionArr[0].trim(), operatorChar, condictionArr[1].trim(), null});
                    continue;
                }
                Logger.error((Object)"Parse SQL condiction error");
                continue;
            }
            condictionList.add(new String[]{originCondiction, null, null, null, null, null});
        }
        for (i = condictionList.size() - 2; i >= 0; --i) {
            condictionList.get((int)i)[5] = condictionList.get(i + 1)[1];
        }
        return condictionList;
    }

    public static String getSQLString(Object argObj) {
        if (argObj == null) {
            return "null";
        }
        if (argObj instanceof List) {
            Object[] objects = ((List)argObj).toArray();
            StringBuilder listValueStr = new StringBuilder("(");
            for (Object obj : objects) {
                String sqlValue = TSQL.getSQLString(obj);
                if (sqlValue == null) continue;
                listValueStr.append(sqlValue);
                listValueStr.append(",");
            }
            return TString.removeSuffix((String)listValueStr.toString()) + ")";
        }
        if (argObj instanceof String) {
            return "'" + argObj.toString() + "'";
        }
        if (argObj instanceof Boolean) {
            if (((Boolean)argObj).booleanValue()) {
                return "true";
            }
            return "false";
        }
        if (argObj instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + dateFormat.format(argObj) + "'";
        }
        return argObj.toString();
    }

    public static String getDataMethod(int databaseType) {
        switch (databaseType) {
            case 1: {
                return "getString";
            }
            case 12: {
                return "getString";
            }
            case -1: {
                return "getString";
            }
            case -15: {
                return "getString";
            }
            case -16: {
                return "getString";
            }
            case 2: {
                return "getBigDecimal";
            }
            case 3: {
                return "getBigDecimal";
            }
            case -7: {
                return "getBoolean";
            }
            case 16: {
                return "getBoolean";
            }
            case -6: {
                return "getByte";
            }
            case 5: {
                return "getShort";
            }
            case 4: {
                return "getInt";
            }
            case -5: {
                return "getLong";
            }
            case 7: {
                return "getFloat";
            }
            case 6: {
                return "getFloat";
            }
            case 8: {
                return "getDouble";
            }
            case -2: {
                return "getBytes";
            }
            case -3: {
                return "getBytes";
            }
            case -4: {
                return "getBytes";
            }
            case 91: {
                return "getDate";
            }
            case 92: {
                return "getTime";
            }
            case 93: {
                return "getTimestamp";
            }
            case 2005: {
                return "getClob";
            }
            case 2004: {
                return "getBlob";
            }
            case 2003: {
                return "getArray";
            }
        }
        return "getString";
    }

    public static int getSqlTypes(Object obj) {
        Class<?> objectClass = obj.getClass();
        if (Character.TYPE == objectClass) {
            return 1;
        }
        if (String.class == objectClass) {
            return 12;
        }
        if (BigDecimal.class == objectClass) {
            return 2;
        }
        if (Boolean.class == objectClass) {
            return -7;
        }
        if (Byte.class == objectClass) {
            return -6;
        }
        if (Short.class == objectClass) {
            return 5;
        }
        if (Integer.class == objectClass) {
            return 4;
        }
        if (Long.class == objectClass) {
            return -5;
        }
        if (Float.class == objectClass) {
            return 6;
        }
        if (Double.class == objectClass) {
            return 8;
        }
        if (Byte[].class == objectClass) {
            return -2;
        }
        if (Date.class == objectClass) {
            return 91;
        }
        if (Time.class == objectClass) {
            return 92;
        }
        if (Timestamp.class == objectClass) {
            return 93;
        }
        if (Clob.class == objectClass) {
            return 2005;
        }
        if (Blob.class == objectClass) {
            return 2004;
        }
        if (Object[].class == objectClass) {
            return 2003;
        }
        return 0;
    }

    public static DataBaseType getDataBaseType(Connection connection) {
        try {
            if (connection.getMetaData().getDriverName().toUpperCase().indexOf("MYSQL") != -1) {
                return DataBaseType.MySql;
            }
            if (connection.getMetaData().getDriverName().toUpperCase().indexOf("MARIADB") != -1) {
                return DataBaseType.Mariadb;
            }
            if (connection.getMetaData().getDriverName().toUpperCase().indexOf("POSTAGE") != -1) {
                return DataBaseType.Postage;
            }
            if (connection.getMetaData().getDriverName().toUpperCase().indexOf("ORACLE") != -1) {
                return DataBaseType.Oracle;
            }
            return DataBaseType.UNKNOW;
        }
        catch (SQLException e) {
            return DataBaseType.UNKNOW;
        }
    }

    public static String wrapSqlField(JdbcOperate jdbcOperate, String sqlField) {
        try {
            Connection connection = jdbcOperate.getConnection();
            DataBaseType dataBaseType = TSQL.getDataBaseType(connection);
            if (dataBaseType.equals((Object)DataBaseType.Mariadb) || dataBaseType.equals((Object)DataBaseType.MySql)) {
                return "`" + sqlField + "`";
            }
            if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
                return "\"" + sqlField + "\"";
            }
            if (dataBaseType.equals((Object)DataBaseType.Postage)) {
                return "`" + sqlField + "`";
            }
            return sqlField;
        }
        catch (SQLException e) {
            Logger.error((Object)"wrap sql field error", (Exception)e);
            return sqlField;
        }
    }

    public static String genMysqlPageSql(String sql, int pageNumber, int pageSize) {
        int pageStart = (pageNumber - 1) * pageSize;
        if (pageSize < 0 || pageNumber < 0) {
            return sql;
        }
        return sql + " limit " + pageStart + ", " + pageSize;
    }

    public static String genPostagePageSql(String sql, int pageNumber, int pageSize) {
        int pageStart = (pageNumber - 1) * pageSize;
        if (pageSize < 0 || pageNumber < 0) {
            return sql;
        }
        return sql + " limit " + pageSize + " offset " + pageStart;
    }

    public static String genOraclePageSql(String sql, int pageNumber, int pageSize) {
        int pageStart = (pageNumber - 1) * pageSize;
        int pageEnd = pageStart + pageSize;
        if (pageSize < 0 || pageNumber < 0) {
            return sql;
        }
        sql = sql.replaceFirst("select", "select rownum rn,");
        sql = "select pageSql.* from (" + sql + " ) pageSql where rn between " + pageStart + " and " + pageEnd;
        return sql;
    }
}

