/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis;

import org.apache.ibatis.session.Configuration;
import org.vxwo.springboot.experience.mybatis.config.MybatisConfig;
import org.vxwo.springboot.experience.mybatis.sql.SqlRender;

public final class GeneralSqlHelper {
    private static boolean camelCaseToUnderscore = false;
    private static SqlRender mybatisSqlRender = new ReservedRender("", "");

    public static void initialize(MybatisConfig config, Configuration sessionConfig) {
        camelCaseToUnderscore = sessionConfig.isMapUnderscoreToCamelCase();
        mybatisSqlRender = new ReservedRender(config.getGeneralSql().getReservedPrefix(), config.getGeneralSql().getReservedStuffix());
    }

    public static SqlRender getRender() {
        return mybatisSqlRender;
    }

    public static boolean isCamelCaseToUnderscore() {
        return camelCaseToUnderscore;
    }

    public static class ReservedRender
    implements SqlRender {
        private final String reservedPrefix;
        private final String reservedStuffix;

        private ReservedRender(String prefix, String stuffix) {
            this.reservedPrefix = prefix;
            this.reservedStuffix = stuffix;
        }

        @Override
        public String reserved(String reserved) {
            return this.reservedPrefix + reserved + this.reservedStuffix;
        }

        @Override
        public String property(String property) {
            return "#{" + property + "}";
        }
    }
}

