/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.vxwo.springboot.experience.mybatis.GeneralSqlHelper;
import org.vxwo.springboot.experience.mybatis.sql.TableEntity;
import org.vxwo.springboot.experience.mybatis.sql.TableParser;

public class GeneralTableCache {
    private static final Map<String, TableEntity> CACHE = new HashMap<String, TableEntity>();
    private static final ReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableEntity findTable(Class<?> type) {
        TableEntity table = null;
        String typeName = type.getName();
        Lock readLock = CACHE_LOCK.readLock();
        readLock.lock();
        table = CACHE.get(typeName);
        readLock.unlock();
        if (table != null) {
            return table;
        }
        Lock writeLock = CACHE_LOCK.writeLock();
        writeLock.lock();
        try {
            table = CACHE.get(typeName);
            if (table == null) {
                table = TableParser.parseTable(type, GeneralSqlHelper.isCamelCaseToUnderscore());
                CACHE.put(typeName, table);
            }
        }
        finally {
            writeLock.unlock();
        }
        return table;
    }
}

