/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis.sql;

import java.util.ArrayList;
import org.apache.ibatis.builder.BuilderException;
import org.vxwo.springboot.experience.mybatis.sql.ColumnEntity;
import org.vxwo.springboot.experience.mybatis.sql.SqlRender;
import org.vxwo.springboot.experience.mybatis.sql.TableEntity;

public final class SqlGenerator {
    private static boolean existsValue(ColumnEntity column, Object value) {
        return column.getFieldValue(value) != null;
    }

    private static String renderColumnSet(SqlRender render, ColumnEntity column) {
        return render.reserved(column.getName()) + "=" + render.property(column.getFieldName());
    }

    public static String insertOne(SqlRender render, TableEntity table, Object value) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ColumnEntity idColumn = table.getIdColumn();
        if (SqlGenerator.existsValue(idColumn, value)) {
            columns.add(render.reserved(idColumn.getName()));
            properties.add(render.property(idColumn.getFieldName()));
        }
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columns.add(render.reserved(column.getName()));
                properties.add(render.property(column.getFieldName()));
            }
        });
        if (columns.isEmpty()) {
            throw new BuilderException("Insert statements must have at least one column");
        }
        return "INSERT INTO " + render.reserved(table.getName()) + " (" + String.join((CharSequence)", ", columns) + ") VALUES (" + String.join((CharSequence)", ", properties) + ")";
    }

    public static String updateOneById(SqlRender render, TableEntity table, Object value) {
        ColumnEntity idColumn = table.getIdColumn();
        if (!SqlGenerator.existsValue(idColumn, value)) {
            throw new BuilderException("Update statements must have value for column 'id'");
        }
        ArrayList columnSets = new ArrayList();
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(SqlGenerator.renderColumnSet(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Update statements must have at least one set phrase");
        }
        return "UPDATE " + render.reserved(table.getName()) + " SET " + String.join((CharSequence)", ", columnSets) + " WHERE " + SqlGenerator.renderColumnSet(render, idColumn);
    }

    public static String selectByColumn(SqlRender render, TableEntity table, Object value) {
        ArrayList<String> columnSets = new ArrayList<String>();
        ColumnEntity idColumn = table.getIdColumn();
        if (SqlGenerator.existsValue(idColumn, value)) {
            columnSets.add(SqlGenerator.renderColumnSet(render, idColumn));
        }
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(SqlGenerator.renderColumnSet(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Select statements must have at least one query expression");
        }
        return "SELECT * FROM " + render.reserved(table.getName()) + " WHERE " + String.join((CharSequence)" AND ", columnSets);
    }

    public static String deleteByColumn(SqlRender render, TableEntity table, Object value) {
        ArrayList<String> columnSets = new ArrayList<String>();
        ColumnEntity idColumn = table.getIdColumn();
        if (SqlGenerator.existsValue(idColumn, value)) {
            columnSets.add(SqlGenerator.renderColumnSet(render, idColumn));
        }
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(SqlGenerator.renderColumnSet(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Delete statements must have at least one query expression");
        }
        return "DELETE FROM " + render.reserved(table.getName()) + " WHERE " + String.join((CharSequence)" AND ", columnSets);
    }
}

