/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.ReflectionException;
import org.springframework.util.StringUtils;
import org.vxwo.springboot.experience.mybatis.annotations.GeneralId;
import org.vxwo.springboot.experience.mybatis.annotations.GeneralTable;
import org.vxwo.springboot.experience.mybatis.sql.ColumnEntity;
import org.vxwo.springboot.experience.mybatis.sql.TableEntity;
import org.vxwo.springboot.experience.util.lang.Tuple2;

public final class TableParser {
    private static String camelToUnderline(String value) {
        if (!StringUtils.hasText((String)value)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (Character.isUpperCase(ch) && i > 0) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    private static String parseGetterName(String fieldName, Class<?> type) {
        String methodPrefix;
        char firstCh = fieldName.charAt(0);
        String string = methodPrefix = type.isInstance(Boolean.class) ? "is" : "get";
        if (Character.isUpperCase(firstCh)) {
            return methodPrefix + fieldName;
        }
        return methodPrefix + Character.toUpperCase(firstCh) + fieldName.substring(1);
    }

    private static Tuple2<List<Field>, Map<String, Method>> parseFieldAndMethods(Class<?> cursorType) {
        HashSet fieldNames = new HashSet();
        HashSet methodNames = new HashSet();
        ArrayList fieldList = new ArrayList();
        HashMap methodMap = new HashMap(50);
        while (cursorType != Object.class) {
            Arrays.stream(cursorType.getDeclaredFields()).filter(field -> !fieldNames.contains(field.getName())).collect(Collectors.toList()).forEach(field -> {
                fieldNames.add(field.getName());
                fieldList.add(field);
            });
            Arrays.stream(cursorType.getMethods()).filter(method -> !methodNames.contains(method.getName())).collect(Collectors.toList()).forEach(method -> {
                methodNames.add(method.getName());
                methodMap.put(method.getName(), method);
            });
            cursorType = cursorType.getSuperclass();
        }
        return Tuple2.of(fieldList, methodMap);
    }

    public static TableEntity parseTable(Class<?> type, boolean camelCaseToUnderscore) {
        String typeName = type.getName();
        GeneralTable tableAnnotation = type.getAnnotation(GeneralTable.class);
        if (tableAnnotation == null) {
            throw new ReflectionException("Not found annotation '@GeneralTable' on class: " + typeName);
        }
        String tableName = tableAnnotation.value();
        if (!StringUtils.hasText((String)tableName)) {
            throw new ReflectionException("Invalid table name in annotation '@GeneralTable' on class: " + typeName);
        }
        Tuple2<List<Field>, Map<String, Method>> fieldAndMehtods = TableParser.parseFieldAndMethods(type);
        int idAnnotationCount = 0;
        ColumnEntity idByName = null;
        ColumnEntity idByAnnotation = null;
        ArrayList<ColumnEntity> columns = new ArrayList<ColumnEntity>();
        for (Field field : (List)fieldAndMehtods.getT1()) {
            boolean foundAnnotation = false;
            GeneralId annotation = field.getAnnotation(GeneralId.class);
            if (annotation != null) {
                ++idAnnotationCount;
                foundAnnotation = true;
            }
            String fieldName = field.getName();
            Method getterMethod = (Method)((Map)fieldAndMehtods.getT2()).get(TableParser.parseGetterName(fieldName, field.getType()));
            if (getterMethod == null) {
                if (!foundAnnotation) continue;
                throw new ReflectionException("Not found 'Getter' with field {" + fieldName + "} in annotation '@GeneralId' on class: " + typeName);
            }
            ColumnEntity column = ColumnEntity.of(camelCaseToUnderscore ? TableParser.camelToUnderline(fieldName) : fieldName, fieldName, getterMethod);
            if (foundAnnotation) {
                idByAnnotation = column;
            } else if ("id".equals(fieldName)) {
                idByName = column;
            }
            columns.add(column);
        }
        if (idAnnotationCount > 1) {
            throw new ReflectionException("Mutiple annotation '@GeneralId' fields on class: " + typeName);
        }
        if (idAnnotationCount < 1 && idByName == null) {
            throw new ReflectionException("Not found 'id' field or none annotation by '@GeneralId' on class: " + typeName);
        }
        ColumnEntity idColumn = idByName != null ? idByName : idByAnnotation;
        return TableEntity.of(tableName, idColumn, columns.stream().filter(o -> o != idColumn).collect(Collectors.toList()));
    }
}

