/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis;

import org.apache.ibatis.session.Configuration;
import org.vxwo.springboot.experience.mybatis.config.MybatisProperties;
import org.vxwo.springboot.experience.mybatis.sql.BaseSqlRender;

public final class GeneralSqlHelper {
    private static Configuration mybatisConfig;
    private static BaseSqlRender mybatisSqlRender;

    public static void initialize(MybatisProperties config, Configuration mybatisConfig) {
        GeneralSqlHelper.mybatisConfig = mybatisConfig;
        mybatisSqlRender = new ReservedSqlRender(config.getGeneralSql().getReservedPrefix(), config.getGeneralSql().getReservedStuffix());
    }

    public static BaseSqlRender getRender() {
        return mybatisSqlRender;
    }

    public static Configuration getConfiguration() {
        return mybatisConfig;
    }

    static {
        mybatisSqlRender = new ReservedSqlRender("", "");
    }

    public static class ReservedSqlRender
    extends BaseSqlRender {
        private final String reservedPrefix;
        private final String reservedStuffix;

        private ReservedSqlRender(String prefix, String stuffix) {
            this.reservedPrefix = prefix;
            this.reservedStuffix = stuffix;
        }

        @Override
        public String renderReserved(String reserved) {
            return this.reservedPrefix + reserved + this.reservedStuffix;
        }
    }
}

