/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.io.ResolverUtil;
import org.vxwo.springboot.experience.mybatis.GeneralSqlHelper;
import org.vxwo.springboot.experience.mybatis.annotations.GeneralTable;
import org.vxwo.springboot.experience.mybatis.sql.TableEntity;
import org.vxwo.springboot.experience.mybatis.sql.TableParser;
import org.vxwo.springboot.experience.util.lang.Tuple2;

public class GeneralTableRegistrar {
    private static final Map<String, TableEntity> TABLE_CACHE = new ConcurrentHashMap<String, TableEntity>();

    public static TableEntity findTable(Class<?> type) {
        String typeName = type.getName();
        TableEntity table = TABLE_CACHE.get(typeName);
        if (table == null) {
            throw new BuilderException("Not found `GeneralTable` for class: " + typeName);
        }
        return table;
    }

    private static Tuple2<String, String> addTableConfig(Class<?> type) {
        String typeName = type.getName();
        TableEntity table = TABLE_CACHE.get(typeName);
        if (table != null) {
            return null;
        }
        table = TableParser.parseTable(type, GeneralSqlHelper.getConfiguration().isMapUnderscoreToCamelCase());
        TABLE_CACHE.put(typeName, table);
        return Tuple2.of((Object)table.getName(), (Object)typeName);
    }

    public static List<Tuple2<String, String>> registerTablesInPackage(String packageName) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.findAnnotated(GeneralTable.class, new String[]{packageName});
        ArrayList<Tuple2<String, String>> result = new ArrayList<Tuple2<String, String>>();
        for (Class type : resolverUtil.getClasses()) {
            Tuple2<String, String> tablePair = GeneralTableRegistrar.addTableConfig(type);
            if (tablePair == null) continue;
            result.add(tablePair);
        }
        return result;
    }
}

