/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.vxwo.springboot.experience.mybatis.GeneralSqlHelper;
import org.vxwo.springboot.experience.mybatis.GeneralTableRegistrar;
import org.vxwo.springboot.experience.mybatis.config.MybatisProperties;
import org.vxwo.springboot.experience.util.lang.Tuple2;

@EnableConfigurationProperties(value={MybatisProperties.class})
public class MybatisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MybatisAutoConfiguration.class);

    @Autowired
    public MybatisAutoConfiguration(MybatisProperties value, SqlSessionFactory sqlSessionFactory, ApplicationContext applicationContext) {
        HashSet basePackages = new HashSet();
        applicationContext.getBeansWithAnnotation(ComponentScan.class).forEach((name, instance) -> {
            basePackages.add(instance.getClass().getPackage().getName());
            for (ComponentScan scan : AnnotatedElementUtils.getMergedRepeatableAnnotations(instance.getClass(), ComponentScan.class)) {
                basePackages.addAll(Arrays.asList(scan.basePackages()));
            }
        });
        ArrayList<Tuple2<String, String>> registerTables = new ArrayList<Tuple2<String, String>>();
        GeneralSqlHelper.initialize(value, sqlSessionFactory.getConfiguration());
        for (String basePackage : basePackages) {
            registerTables.addAll(GeneralTableRegistrar.registerTablesInPackage(basePackage));
        }
        if (log.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(registerTables.size() + " tables");
            for (Tuple2 tuple2 : registerTables) {
                sb.append("\n table: " + (String)tuple2.getT1() + ", type: " + (String)tuple2.getT2());
            }
            log.info("MyBatis actived, " + sb.toString());
        }
    }
}

