/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.springframework.util.StringUtils;
import org.vxwo.springboot.experience.util.json.ObjectMapperBuilder;

public abstract class BaseJsonTypeHandler<T>
extends BaseTypeHandler<T> {
    protected static final ObjectMapper OBJECT_MAPPER = ObjectMapperBuilder.builder().useDefault().build();

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setString(i, OBJECT_MAPPER.writeValueAsString(parameter));
        }
        catch (JsonProcessingException ex) {
            throw new SQLException(ex);
        }
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String json = rs.getString(columnName);
        return !StringUtils.hasText((String)json) ? null : (T)this.parseValue(json);
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String json = rs.getString(columnIndex);
        return !StringUtils.hasText((String)json) ? null : (T)this.parseValue(json);
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String json = cs.getString(columnIndex);
        return !StringUtils.hasText((String)json) ? null : (T)this.parseValue(json);
    }

    private T parseValue(String json) throws SQLException {
        try {
            return (T)OBJECT_MAPPER.readValue(json, this.getGenericValueType());
        }
        catch (JsonProcessingException ex) {
            throw new SQLException(ex);
        }
    }

    protected abstract JavaType getGenericValueType();
}

