/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis.sql;

import java.lang.reflect.Method;
import org.apache.ibatis.type.TypeHandler;

public final class ColumnEntity {
    private final String name;
    private final String fieldName;
    private final Method fieldGetter;
    private final boolean allowAdd;
    private final Class<? extends TypeHandler> typeHandler;

    private ColumnEntity(String name, String fieldName, Method fieldGetter, boolean allowAdd, Class<? extends TypeHandler> typeHandler) {
        this.name = name;
        this.fieldName = fieldName;
        this.fieldGetter = fieldGetter;
        this.allowAdd = allowAdd;
        this.typeHandler = typeHandler;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getFieldValue(Object object) {
        try {
            return this.fieldGetter.invoke(object, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isAllowAdd() {
        return this.allowAdd;
    }

    public String getFieldTypeHandlerName() {
        return this.typeHandler == null ? null : this.typeHandler.getName();
    }

    public static ColumnEntity of(String columnName, String fieldName, Method fieldGetter, boolean allowAdd, Class<? extends TypeHandler> typeHandler) {
        return new ColumnEntity(columnName, fieldName, fieldGetter, allowAdd, typeHandler);
    }
}

