/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.mybatis.sql;

import java.util.ArrayList;
import org.apache.ibatis.builder.BuilderException;
import org.vxwo.springboot.experience.mybatis.sql.BaseSqlRender;
import org.vxwo.springboot.experience.mybatis.sql.ColumnEntity;
import org.vxwo.springboot.experience.mybatis.sql.TableEntity;

public final class SqlGenerator {
    private static boolean existsValue(ColumnEntity column, Object value) {
        return column.getFieldValue(value) != null;
    }

    private static String renderColumnSet(BaseSqlRender render, ColumnEntity column) {
        return render.renderReserved(column.getName()) + "=" + render.renderProperty(column.getFieldName(), column.getFieldTypeHandlerName());
    }

    private static String renderColumnSetAdd(BaseSqlRender render, ColumnEntity column) {
        String columnName = render.renderReserved(column.getName());
        return columnName + "=" + columnName + "+" + render.renderProperty(column.getFieldName(), column.getFieldTypeHandlerName());
    }

    public static String insertOne(BaseSqlRender render, TableEntity table, Object value) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ColumnEntity idColumn = table.getIdColumn();
        if (SqlGenerator.existsValue(idColumn, value)) {
            columns.add(render.renderReserved(idColumn.getName()));
            properties.add(render.renderProperty(idColumn.getFieldName(), idColumn.getFieldTypeHandlerName()));
        }
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columns.add(render.renderReserved(column.getName()));
                properties.add(render.renderProperty(column.getFieldName(), column.getFieldTypeHandlerName()));
            }
        });
        if (columns.isEmpty()) {
            throw new BuilderException("Insert statements must have at least one column");
        }
        return "INSERT INTO " + render.renderReserved(table.getName()) + " (" + String.join((CharSequence)", ", columns) + ") VALUES (" + String.join((CharSequence)", ", properties) + ")";
    }

    public static String updateOneById(BaseSqlRender render, TableEntity table, Object value) {
        ColumnEntity idColumn = table.getIdColumn();
        if (!SqlGenerator.existsValue(idColumn, value)) {
            throw new BuilderException("Update statements must have value for column 'id'");
        }
        ArrayList columnSets = new ArrayList();
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(SqlGenerator.renderColumnSet(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Update statements must have at least one set phrase");
        }
        return "UPDATE " + render.renderReserved(table.getName()) + " SET " + String.join((CharSequence)", ", columnSets) + " WHERE " + SqlGenerator.renderColumnSet(render, idColumn);
    }

    public static String updateOneAddById(BaseSqlRender render, TableEntity table, Object value) {
        ColumnEntity idColumn = table.getIdColumn();
        if (!SqlGenerator.existsValue(idColumn, value)) {
            throw new BuilderException("Update statements must have value for column 'id'");
        }
        ArrayList columnSets = new ArrayList();
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(!column.isAllowAdd() ? SqlGenerator.renderColumnSet(render, column) : SqlGenerator.renderColumnSetAdd(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Update statements must have at least one set phrase");
        }
        return "UPDATE " + render.renderReserved(table.getName()) + " SET " + String.join((CharSequence)", ", columnSets) + " WHERE " + SqlGenerator.renderColumnSet(render, idColumn);
    }

    public static String selectByColumn(BaseSqlRender render, TableEntity table, Object value) {
        ArrayList<String> columnSets = new ArrayList<String>();
        ColumnEntity idColumn = table.getIdColumn();
        if (SqlGenerator.existsValue(idColumn, value)) {
            columnSets.add(SqlGenerator.renderColumnSet(render, idColumn));
        }
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(SqlGenerator.renderColumnSet(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Select statements must have at least one query expression");
        }
        return "SELECT * FROM " + render.renderReserved(table.getName()) + " WHERE " + String.join((CharSequence)" AND ", columnSets);
    }

    public static String deleteByColumn(BaseSqlRender render, TableEntity table, Object value) {
        ArrayList<String> columnSets = new ArrayList<String>();
        ColumnEntity idColumn = table.getIdColumn();
        if (SqlGenerator.existsValue(idColumn, value)) {
            columnSets.add(SqlGenerator.renderColumnSet(render, idColumn));
        }
        table.getOtherColumns().forEach(column -> {
            if (SqlGenerator.existsValue(column, value)) {
                columnSets.add(SqlGenerator.renderColumnSet(render, column));
            }
        });
        if (columnSets.isEmpty()) {
            throw new BuilderException("Delete statements must have at least one query expression");
        }
        return "DELETE FROM " + render.renderReserved(table.getName()) + " WHERE " + String.join((CharSequence)" AND ", columnSets);
    }
}

