/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.redis.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.vxwo.springboot.experience.redis.config.RedisConfig;
import org.vxwo.springboot.experience.redis.processor.RedisFrequencyProcessor;
import org.vxwo.springboot.experience.redis.render.RedisTemplateRender;
import org.vxwo.springboot.experience.redis.serializer.RedisPrefixWrapper;

@Configuration
public class RedisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisAutoConfiguration.class);
    private String redisNamespace;

    @Autowired
    public RedisAutoConfiguration(RedisConfig value) {
        this.redisNamespace = value.getNamespace();
        if (!this.redisNamespace.isEmpty() && !this.redisNamespace.endsWith(value.getNamespaceStuffix())) {
            this.redisNamespace = this.redisNamespace + value.getNamespaceStuffix();
        }
        if (log.isInfoEnabled()) {
            log.info("Redis actived, namespace: \"" + this.redisNamespace + "\"");
        }
    }

    @Bean
    public RedisPrefixWrapper redisPrefixWrapper() {
        return new RedisPrefixWrapper(this.redisNamespace);
    }

    @Bean
    public RedisTemplateRender redisTemplateRender(RedisConnectionFactory redisConnectionFactory) {
        return new RedisTemplateRender(this.redisNamespace, redisConnectionFactory);
    }

    @Bean
    public RedisFrequencyProcessor redisFrequencyProcessor(RedisTemplateRender render) {
        return new RedisFrequencyProcessor(render);
    }
}

