/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.redis.processor;

import java.time.Duration;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.vxwo.springboot.experience.redis.entity.FrequencyDurationSession;
import org.vxwo.springboot.experience.redis.render.RedisTemplateRender;

public class RedisFrequencyProcessor {
    private static final AtomicLong SAFE_ATOM = new AtomicLong();
    private static final RedisScript<Boolean> UNSAFE_LOCK_SCRIPT = new DefaultRedisScript("if redis.call('SET', KEYS[1], ARGV[1], 'NX', 'PX', ARGV[2]) then return true else return false end", Boolean.class);
    private static final RedisScript<Boolean> UNSAFE_UNLOCK_SCRIPT = new DefaultRedisScript("if redis.call('GET', KEYS[1]) == ARGV[1] then redis.call('DEL', KEYS[1]) return true else return false end", Boolean.class);
    private final RedisTemplate<String, String> redisTemplate = new RedisTemplate();

    public RedisFrequencyProcessor(RedisTemplateRender render) {
        render.renderStringTemplate(this.redisTemplate);
    }

    public FrequencyDurationSession enterFrequencyDuration(String frequencyKey, Duration duration) {
        String frequencyValue = UUID.randomUUID().toString() + ":" + SAFE_ATOM.getAndIncrement();
        Boolean result = (Boolean)this.redisTemplate.execute(UNSAFE_LOCK_SCRIPT, Collections.singletonList(frequencyKey), new Object[]{frequencyValue, String.valueOf(duration.toMillis())});
        return result != false ? new FrequencyDurationSession(frequencyKey, frequencyValue) : null;
    }

    public boolean leaveFrequencyDuration(FrequencyDurationSession session) {
        return (Boolean)this.redisTemplate.execute(UNSAFE_UNLOCK_SCRIPT, Collections.singletonList(session.getFrequencyKey()), new Object[]{session.getFrequencyValue()});
    }
}

