/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.redis.render;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.vxwo.springboot.experience.redis.serializer.RedisPrefixKeySerializer;

public class RedisTemplateRender {
    private final ObjectMapper objectMapper;
    private final RedisConnectionFactory connectionFactory;
    private final RedisPrefixKeySerializer keyPrefixSerializer;
    private static final StringRedisSerializer STRING_SERIALIZER = new StringRedisSerializer();

    public RedisTemplateRender(String keyPrefix, RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.keyPrefixSerializer = new RedisPrefixKeySerializer(keyPrefix);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new ParameterNamesModule());
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
    }

    public void renderStringTemplate(RedisTemplate<String, String> template) {
        template.setConnectionFactory(this.connectionFactory);
        template.setKeySerializer((RedisSerializer)this.keyPrefixSerializer);
        template.setValueSerializer((RedisSerializer)STRING_SERIALIZER);
        template.setHashKeySerializer((RedisSerializer)STRING_SERIALIZER);
        template.setHashValueSerializer((RedisSerializer)STRING_SERIALIZER);
        template.afterPropertiesSet();
    }

    public <T> void renderGenericTemplate(RedisTemplate<String, T> template, Class<T> valueClass) {
        Jackson2JsonRedisSerializer valueSerializer = new Jackson2JsonRedisSerializer(valueClass);
        valueSerializer.setObjectMapper(this.objectMapper);
        template.setConnectionFactory(this.connectionFactory);
        template.setKeySerializer((RedisSerializer)this.keyPrefixSerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashKeySerializer((RedisSerializer)STRING_SERIALIZER);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
    }
}

