/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.util.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import org.vxwo.springboot.experience.util.json.ObjectMapperRender;

public class ObjectMapperBuilder {
    private ObjectMapper objectMapper = new ObjectMapper();

    private ObjectMapperBuilder() {
    }

    public ObjectMapperBuilder useDefault() {
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new ParameterNamesModule());
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        return this;
    }

    public ObjectMapperBuilder useRender(ObjectMapperRender render) {
        render.render(this.objectMapper);
        return this;
    }

    public ObjectMapper build() {
        return this.objectMapper;
    }

    public static ObjectMapperBuilder builder() {
        return new ObjectMapperBuilder();
    }
}

