/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.vxwo.springboot.experience.web.config.ApiKeyAuthorizationProperties;
import org.vxwo.springboot.experience.web.config.BearerAuthorizationProperties;
import org.vxwo.springboot.experience.web.config.CorsProperties;
import org.vxwo.springboot.experience.web.config.FrequencyControlProperties;
import org.vxwo.springboot.experience.web.config.ManualAuthorizationProperties;
import org.vxwo.springboot.experience.web.config.RequestLoggingProperties;
import org.vxwo.springboot.experience.web.filter.ApiKeyAuthorizationFilter;
import org.vxwo.springboot.experience.web.filter.BearerAuthorizationFilter;
import org.vxwo.springboot.experience.web.filter.CorsFilter;
import org.vxwo.springboot.experience.web.filter.FrequencyControlFilter;
import org.vxwo.springboot.experience.web.filter.ManualAuthorizationFilter;
import org.vxwo.springboot.experience.web.filter.RequestLoggingAspect;
import org.vxwo.springboot.experience.web.filter.RequestLoggingFilter;
import org.vxwo.springboot.experience.web.filter.SecondaryAuthorizationFilter;
import org.vxwo.springboot.experience.web.processor.PathDocumentHelper;
import org.vxwo.springboot.experience.web.processor.PathProcessor;
import org.vxwo.springboot.experience.web.processor.RequestLoggingHelper;

@EnableConfigurationProperties(value={CorsProperties.class, RequestLoggingProperties.class, ApiKeyAuthorizationProperties.class, BearerAuthorizationProperties.class, ManualAuthorizationProperties.class, FrequencyControlProperties.class})
public class WebAutoConfiguration {
    @Bean
    public PathProcessor pathProcessor() {
        return new PathProcessor();
    }

    @Bean
    public PathDocumentHelper pathDocumentHelper() {
        return new PathDocumentHelper();
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.cors.enabled"}, havingValue="true")
    @Order(value=-2147483648)
    public CorsFilter corsFilter(CorsProperties value) {
        return new CorsFilter(value);
    }

    @Bean
    public RequestLoggingHelper requestLoggingHelper(RequestLoggingProperties value) {
        return new RequestLoggingHelper(value);
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.logging.enabled"}, havingValue="true")
    @Order(value=-2147483647)
    public RequestLoggingFilter requestLoggingFilter(RequestLoggingProperties value) {
        return new RequestLoggingFilter(value);
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.logging.enabled"}, havingValue="true")
    public RequestLoggingAspect requestLoggingAspect() {
        return new RequestLoggingAspect();
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.authorization.api-key.enabled"}, havingValue="true")
    @Order(value=-2147473647)
    public ApiKeyAuthorizationFilter apiKeyAuthorizationFilter(ApiKeyAuthorizationProperties value) {
        return new ApiKeyAuthorizationFilter(value);
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.authorization.bearer.enabled"}, havingValue="true")
    @Order(value=-2147473646)
    public BearerAuthorizationFilter bearerAuthorizationFilter(BearerAuthorizationProperties value) {
        return new BearerAuthorizationFilter(value);
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.authorization.manual.enabled"}, havingValue="true")
    @Order(value=-2147473645)
    public ManualAuthorizationFilter manualAuthorizationFilter(ManualAuthorizationProperties value) {
        return new ManualAuthorizationFilter(value);
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.frequency-control.enabled"}, havingValue="true")
    @Order(value=-2147463648)
    public FrequencyControlFilter frequencyControlFilter(FrequencyControlProperties value) {
        return new FrequencyControlFilter(value);
    }

    @Bean
    @ConditionalOnProperty(value={"sbexp.web.authorization.secondary.enabled"}, havingValue="true")
    @Order(value=-2147453648)
    public SecondaryAuthorizationFilter secondaryAuthorizationFilter() {
        return new SecondaryAuthorizationFilter();
    }
}

