/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.filter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.vxwo.springboot.experience.web.config.ApiKeyAuthorizationProperties;
import org.vxwo.springboot.experience.web.filter.AuthorizationHelper;
import org.vxwo.springboot.experience.web.handler.AuthorizationFailureHandler;
import org.vxwo.springboot.experience.web.matcher.OwnerPathRuleMatcher;
import org.vxwo.springboot.experience.web.matcher.PathRuleMatcher;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;
import org.vxwo.springboot.experience.web.processor.PathProcessor;
import org.vxwo.springboot.experience.web.util.SplitUtil;

public class ApiKeyAuthorizationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyAuthorizationFilter.class);
    private final List<String> headerKeys;
    private final boolean parseBearer;
    private final List<String> bearerKeys;
    private final OwnerPathRuleMatcher pathRuleMatcher;
    @Autowired
    private PathProcessor pathProcessor;
    @Autowired
    private AuthorizationFailureHandler failureHandler;

    public ApiKeyAuthorizationFilter(ApiKeyAuthorizationProperties value) {
        this.headerKeys = SplitUtil.shrinkList(value.getHeaderKeys());
        this.parseBearer = value.isParseBearer();
        this.bearerKeys = value.getBearerKeys();
        this.pathRuleMatcher = new OwnerPathRuleMatcher("sbexp.web.authorization.api-key.path-rules", value.getPathRules());
        if (log.isInfoEnabled()) {
            log.info("ApiKey authorization actived, " + this.pathRuleMatcher.toString());
        }
    }

    public PathRuleMatcher getPathRuleMatcher() {
        return this.pathRuleMatcher;
    }

    private String parseApiKeyFromHeader(HttpServletRequest request) {
        List<String> fields;
        String authorization;
        String key;
        String apiKey = null;
        Iterator<String> iterator = this.headerKeys.iterator();
        while (iterator.hasNext() && (apiKey = request.getHeader(key = iterator.next())) == null) {
        }
        if (apiKey == null && this.parseBearer && (authorization = request.getHeader("Authorization")) != null && (fields = SplitUtil.splitToList(authorization, " ")).size() > 1 && this.bearerKeys.contains(fields.get(0))) {
            apiKey = fields.get(1);
        }
        return apiKey;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (AuthorizationHelper.isProcessed(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        TagPathTester<Map<String, String>> tester = this.pathRuleMatcher.findMatchTester(this.pathProcessor.getRelativeURI(request));
        if (tester == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String apiKey = this.parseApiKeyFromHeader(request);
        if (apiKey == null) {
            this.failureHandler.handleAuthorizationFailure(request, response, tester.getTag(), tester.getPath(), "no-api-key");
        } else {
            String keyOwner = tester.getExtra().get(apiKey);
            if (keyOwner != null) {
                AuthorizationHelper.markProcessed(request, tester);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.failureHandler.handleAuthorizationFailure(request, response, tester.getTag(), tester.getPath(), "invalid-api-key");
            }
        }
    }
}

