/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.vxwo.springboot.experience.web.config.BearerAuthorizationProperties;
import org.vxwo.springboot.experience.web.filter.AuthorizationHelper;
import org.vxwo.springboot.experience.web.handler.AuthorizationFailureHandler;
import org.vxwo.springboot.experience.web.handler.BearerAuthorizationHandler;
import org.vxwo.springboot.experience.web.matcher.GroupPathRuleMatcher;
import org.vxwo.springboot.experience.web.matcher.PathRuleMatcher;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;
import org.vxwo.springboot.experience.web.processor.PathProcessor;
import org.vxwo.springboot.experience.web.util.SplitUtil;

public class BearerAuthorizationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(BearerAuthorizationFilter.class);
    private final List<String> bearerKeys;
    private final GroupPathRuleMatcher pathRuleMatcher;
    @Autowired
    private PathProcessor pathProcessor;
    @Autowired
    private BearerAuthorizationHandler processHandler;
    @Autowired
    private AuthorizationFailureHandler failureHandler;

    public BearerAuthorizationFilter(BearerAuthorizationProperties value) {
        this.bearerKeys = value.getBearerKeys();
        this.pathRuleMatcher = new GroupPathRuleMatcher("sbexp.web.authorization.bearer.path-rules", value.getPathRules());
        if (log.isInfoEnabled()) {
            log.info("Bearer authorization actived, " + this.pathRuleMatcher.toString());
        }
    }

    public PathRuleMatcher getPathRuleMatcher() {
        return this.pathRuleMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        List<String> fields;
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (AuthorizationHelper.isProcessed(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String relativePath = this.pathProcessor.getRelativeURI(request);
        TagPathTester<GroupPathRuleMatcher.ExcludesAndOptionals> tester = this.pathRuleMatcher.findMatchTester(relativePath);
        if (tester == null || tester.getExtra().isExclude(relativePath)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String bearerToken = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && (fields = SplitUtil.splitToList(authorization, " ")).size() > 1 && this.bearerKeys.contains(fields.get(0))) {
            bearerToken = fields.get(1);
        }
        if (bearerToken == null && tester.getExtra().isOptional(relativePath)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (bearerToken == null) {
            this.failureHandler.handleAuthorizationFailure(request, response, tester.getTag(), tester.getPath(), "no-bearer-token");
        } else if (this.processHandler.processBearerAuthorization(request, response, tester.getTag(), tester.getPath(), bearerToken)) {
            AuthorizationHelper.markProcessed(request, tester);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.failureHandler.handleAuthorizationFailure(request, response, tester.getTag(), tester.getPath(), "invalid-bearer-handle");
        }
    }
}

