/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.vxwo.springboot.experience.web.config.CorsProperties;
import org.vxwo.springboot.experience.web.util.SplitUtil;

public class CorsFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CorsFilter.class);
    private static final String ORIGIN_ALL = "*";
    private final boolean parseReferer;
    private final String firstAllowOrigin;
    private final List<String> acceptAllowOrigins;

    public CorsFilter(CorsProperties value) {
        this.parseReferer = value.isParseReferer();
        this.acceptAllowOrigins = SplitUtil.shrinkList(value.getAllowOrigins());
        String string = this.firstAllowOrigin = this.acceptAllowOrigins.isEmpty() ? null : this.acceptAllowOrigins.get(0);
        if (log.isInfoEnabled()) {
            log.info("CORS actived");
        }
    }

    private static String parseOriginFromHeader(HttpServletRequest request, boolean parseReferer) {
        String allowOrigin = request.getHeader("Origin");
        if (StringUtils.hasText((String)allowOrigin)) {
            return allowOrigin;
        }
        String referer = request.getHeader("Referer");
        if (parseReferer && StringUtils.hasText((String)referer)) {
            int pos = -1;
            if (referer.startsWith("http://")) {
                pos = 7;
            } else if (referer.startsWith("https://")) {
                pos = 8;
            }
            if (pos != -1) {
                int end = referer.indexOf("/", pos);
                String string = allowOrigin = end == -1 ? referer : referer.substring(0, end);
            }
        }
        if (!StringUtils.hasText((String)allowOrigin)) {
            allowOrigin = ORIGIN_ALL;
        }
        return allowOrigin;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String allowOrigin = null;
        boolean requireVaryHeader = false;
        if (this.acceptAllowOrigins.isEmpty()) {
            requireVaryHeader = true;
            allowOrigin = CorsFilter.parseOriginFromHeader(request, this.parseReferer);
        } else if (this.acceptAllowOrigins.size() == 1) {
            allowOrigin = this.firstAllowOrigin;
        } else {
            requireVaryHeader = true;
            allowOrigin = CorsFilter.parseOriginFromHeader(request, true);
            if (!this.acceptAllowOrigins.contains(allowOrigin)) {
                allowOrigin = this.firstAllowOrigin;
            }
        }
        if (requireVaryHeader) {
            response.setHeader("Vary", "Origin");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", ORIGIN_ALL);
        response.setHeader("Access-Control-Allow-Headers", ORIGIN_ALL);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Expose-Headers", ORIGIN_ALL);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

