/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.filter;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.vxwo.springboot.experience.web.config.FrequencyControlProperties;
import org.vxwo.springboot.experience.web.handler.FrequencyControlFailureHandler;
import org.vxwo.springboot.experience.web.handler.FrequencyControlHandler;
import org.vxwo.springboot.experience.web.matcher.PathTester;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;
import org.vxwo.springboot.experience.web.processor.PathProcessor;
import org.vxwo.springboot.experience.web.util.SplitUtil;

public class FrequencyControlFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(FrequencyControlFilter.class);
    private final Duration concurrencyDuration;
    private final List<PathTester> concurrencyIncludePaths;
    private final List<TagPathTester<Duration>> fixedIntervals;
    @Autowired
    private PathProcessor pathProcessor;
    @Autowired
    private FrequencyControlHandler processHandler;
    @Autowired
    private FrequencyControlFailureHandler failureHandler;

    public FrequencyControlFilter(FrequencyControlProperties value) {
        if (value.getConcurrency().getDurationMs() < 1) {
            throw new RuntimeException(String.format("Configuration: {%s.concurrency.duration-ms} less then 1", "sbexp.web.frequency-control"));
        }
        this.concurrencyDuration = Duration.ofMillis(value.getConcurrency().getDurationMs());
        this.concurrencyIncludePaths = new ArrayList<PathTester>();
        for (String path : SplitUtil.shrinkList(value.getConcurrency().getIncludePaths())) {
            if (PathTester.isPattern(path)) {
                throw new RuntimeException(String.format("Configuration: {%s.concurrency.include-paths} has pattern character", "sbexp.web.frequency-control"));
            }
            this.concurrencyIncludePaths.add(new PathTester(path));
        }
        this.fixedIntervals = new ArrayList<TagPathTester<Duration>>();
        for (int i = 0; i < value.getFixedIntervals().size(); ++i) {
            FrequencyControlProperties.FixedInterval s = value.getFixedIntervals().get(i);
            String configPathName = String.format("%s.fixed-intervals.[%d]", "sbexp.web.frequency-control", i);
            if (s.getDurationMs() < 1) {
                throw new RuntimeException(String.format("Configuration: {%s.duration-ms} less then 1", configPathName));
            }
            Duration duration = Duration.ofMillis(s.getDurationMs());
            for (String path : SplitUtil.shrinkList(s.getIncludePaths())) {
                if (PathTester.isPattern(path)) {
                    throw new RuntimeException(String.format("Configuration: {%s.include-paths} has pattern character", configPathName));
                }
                this.fixedIntervals.add(new TagPathTester<Duration>(s.getTag(), path, duration));
            }
        }
        if (log.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Request frequency control actived");
            sb.append("\n fixed-intervals:");
            if (this.fixedIntervals.isEmpty()) {
                sb.append(" disabled");
            } else {
                for (TagPathTester<Duration> s : this.fixedIntervals) {
                    sb.append("\n  tag: " + s.getTag() + ", duration: " + s.getExtra().toMillis() + "ms, path: " + s.toPathMatch());
                }
            }
            sb.append("\n concurrency:");
            if (this.concurrencyIncludePaths.isEmpty()) {
                sb.append(" disabled");
            } else {
                sb.append("\n  duration: " + this.concurrencyDuration.toMillis() + "ms");
                sb.append("\n  include-paths:" + String.join((CharSequence)"", this.concurrencyIncludePaths.stream().map(o -> "\n   " + o.toPathMatch()).collect(Collectors.toList())));
            }
            log.info(sb.toString());
        }
    }

    private static String pathToKeyPrefix(String path) {
        return "frequency-control:" + path.replaceAll("/", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HashMap<String, Object> localContext;
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String method = request.getMethod();
        String relativePath = this.pathProcessor.getRelativeURI(request);
        TagPathTester<Duration> fixedInterval = null;
        for (TagPathTester<Duration> s : this.fixedIntervals) {
            if (!s.test(relativePath)) continue;
            fixedInterval = s;
            break;
        }
        String pathKeyPrefix = null;
        if (fixedInterval != null) {
            if (pathKeyPrefix == null) {
                pathKeyPrefix = FrequencyControlFilter.pathToKeyPrefix(relativePath);
            }
            if (this.processHandler.obtainFixedInterval(request, response, pathKeyPrefix, fixedInterval.getExtra())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.failureHandler.handleFrequencyControlFixedIntervalFailure(request, response, method, fixedInterval.getTag(), fixedInterval.getPath());
            }
            return;
        }
        PathTester concurrency = null;
        for (PathTester s : this.concurrencyIncludePaths) {
            if (!s.test(relativePath)) continue;
            concurrency = s;
            break;
        }
        if (concurrency == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (pathKeyPrefix == null) {
            pathKeyPrefix = FrequencyControlFilter.pathToKeyPrefix(relativePath);
        }
        if (this.processHandler.enterConcurrency(request, response, pathKeyPrefix, this.concurrencyDuration, localContext = new HashMap<String, Object>(10))) {
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                this.processHandler.leaveConcurrency(request, response, localContext);
            }
        } else {
            this.failureHandler.handleFrequencyControlConcurrencyFailure(request, response, method, concurrency.getPath());
        }
    }
}

