/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.vxwo.springboot.experience.web.config.RequestLoggingProperties;
import org.vxwo.springboot.experience.web.entity.RequestLoggingEntity;
import org.vxwo.springboot.experience.web.handler.RequestLoggingHandler;
import org.vxwo.springboot.experience.web.matcher.PathTester;
import org.vxwo.springboot.experience.web.processor.PathProcessor;

public class RequestLoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingFilter.class);
    private final boolean ignoreRequestHeaders;
    private final boolean includeRequestHeaderAllKey;
    private final List<String> includeRequestHeaderKeys;
    private final boolean ignoreResponseHeaders;
    private final boolean includeResponseHeaderAllKey;
    private final List<String> includeResponseHeaderKeys;
    private final int responseBodyLimit;
    private final List<PathTester> includePaths;
    @Value(value="${spring.application.name:unknow}")
    private String applicationName;
    @Autowired
    private PathProcessor pathProcessor;
    @Autowired
    private RequestLoggingHandler processHandler;

    public RequestLoggingFilter(RequestLoggingProperties value) {
        HashSet requestHeaderKeys = new HashSet();
        if (ObjectUtils.isEmpty(value.getRequestHeaderKeys()) || value.getRequestHeaderKeys().contains("*")) {
            this.includeRequestHeaderAllKey = true;
        } else {
            this.includeRequestHeaderAllKey = false;
            value.getRequestHeaderKeys().forEach(o -> requestHeaderKeys.add(o.toUpperCase()));
        }
        this.ignoreRequestHeaders = value.isIgnoreRequestHeaders();
        this.includeRequestHeaderKeys = Collections.unmodifiableList(new ArrayList(requestHeaderKeys));
        HashSet responseHeaderKeys = new HashSet();
        if (ObjectUtils.isEmpty(value.getResponseHeaderKeys()) || value.getResponseHeaderKeys().contains("*")) {
            this.includeResponseHeaderAllKey = true;
        } else {
            this.includeResponseHeaderAllKey = false;
            value.getResponseHeaderKeys().forEach(o -> responseHeaderKeys.add(o.toUpperCase()));
        }
        this.ignoreResponseHeaders = value.isIgnoreResponseHeaders();
        this.includeResponseHeaderKeys = Collections.unmodifiableList(new ArrayList(responseHeaderKeys));
        this.responseBodyLimit = value.getResponseBodyLimitKb() * 1024;
        this.includePaths = new ArrayList<PathTester>();
        for (String path : value.getIncludePaths()) {
            if (ObjectUtils.isEmpty((Object)path)) continue;
            this.includePaths.add(new PathTester(path));
        }
        if (log.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Request logging actived, " + this.includePaths.size() + " paths");
            for (PathTester s : this.includePaths) {
                sb.append("\n " + s.toPathMatch());
            }
            log.info(sb.toString());
        }
    }

    private static boolean isIp(String ip) {
        return StringUtils.hasText((String)ip) && !"unknown".equalsIgnoreCase(ip);
    }

    private static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (!RequestLoggingFilter.isIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (!RequestLoggingFilter.isIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (!RequestLoggingFilter.isIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (!RequestLoggingFilter.isIp(ip)) {
            ip = request.getRemoteAddr();
        }
        return RequestLoggingFilter.isIp(ip) ? ip : "";
    }

    private static String getRequestHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (host == null) {
            host = request.getHeader("Host");
        }
        if (host == null) {
            host = request.getServerName();
        }
        return StringUtils.hasText((String)host) ? host : "";
    }

    private String parseResponseBody(ContentCachingResponseWrapper response) {
        int contentSize = response.getContentSize();
        if (contentSize < 1) {
            return "@ignore: empty";
        }
        if (contentSize >= this.responseBodyLimit) {
            return "@ignore: size gt " + this.responseBodyLimit;
        }
        boolean isText = false;
        boolean isJson = false;
        String contentType = response.getContentType();
        if (contentType == null) {
            isText = true;
        } else {
            isText = contentType.startsWith("text/");
            isJson = contentType.startsWith("application/json");
        }
        if (isText || isJson) {
            String responseText = new String(response.getContentAsByteArray(), StandardCharsets.UTF_8);
            return responseText;
        }
        return "@byte[" + contentSize + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String relativePath = this.pathProcessor.getRelativeURI(request);
        PathTester matcher = null;
        for (PathTester s : this.includePaths) {
            if (!s.test(relativePath)) continue;
            matcher = s;
            break;
        }
        if (matcher == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RequestLoggingEntity entity = new RequestLoggingEntity();
        entity.setApplication(this.applicationName);
        entity.setTimeStart(System.currentTimeMillis());
        entity.setRequestHost(RequestLoggingFilter.getRequestHost(request));
        entity.setRequestUri(request.getRequestURI());
        entity.setRequestMethod(request.getMethod());
        entity.setRequestQuery(request.getQueryString());
        entity.setRequestType(request.getContentType());
        entity.setRequestLength(request.getContentLength());
        entity.setClientIp(RequestLoggingFilter.getClientIp(request));
        if (!this.ignoreRequestHeaders) {
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                if (!this.includeRequestHeaderAllKey && !this.includeRequestHeaderKeys.contains(key.toUpperCase())) continue;
                entity.getRequestHeaders().put(key, request.getHeader(key));
            }
        }
        ContentCachingResponseWrapper cachedResponse = new ContentCachingResponseWrapper(response);
        request.setAttribute(RequestLoggingEntity.ATTRIBUTE_NAME, (Object)entity);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)cachedResponse);
        }
        finally {
            entity.setResponseStatus(cachedResponse.getStatus());
            entity.setResponseLength(cachedResponse.getContentSize());
            entity.setResponseType(cachedResponse.getContentType());
            entity.setTimeDuration(System.currentTimeMillis() - entity.getTimeStart());
            if (!this.ignoreResponseHeaders) {
                for (String key : cachedResponse.getHeaderNames()) {
                    if (!this.includeResponseHeaderAllKey && !this.includeResponseHeaderKeys.contains(key.toUpperCase())) continue;
                    entity.getResponseHeaders().put(key, cachedResponse.getHeader(key));
                }
            }
            try {
                if (entity.getResponseBody() == null) {
                    entity.setResponseBody(this.parseResponseBody(cachedResponse));
                }
            }
            catch (Exception ex) {
                entity.setResponseBody("@error: Failed on parse response");
            }
            finally {
                cachedResponse.copyBodyToResponse();
            }
            try {
                this.processHandler.publishRequestLogging(entity);
            }
            catch (Exception ex) {
                log.error("publishRequestLogging", (Throwable)ex);
            }
        }
    }
}

