/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.vxwo.springboot.experience.web.filter.AuthorizationHelper;
import org.vxwo.springboot.experience.web.handler.AuthorizationFailureHandler;
import org.vxwo.springboot.experience.web.handler.SecondaryAuthorizationHandler;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;

public class SecondaryAuthorizationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SecondaryAuthorizationFilter.class);
    @Autowired
    private AuthorizationFailureHandler failureHandler;
    @Autowired
    private SecondaryAuthorizationHandler processHandler;

    public SecondaryAuthorizationFilter() {
        if (log.isInfoEnabled()) {
            log.info("Secondary authorization actived");
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        TagPathTester<?> tester = AuthorizationHelper.getProcessTester(request);
        if (tester == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.processHandler.processSecondaryAuthorization(request, response)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.failureHandler.handleAuthorizationFailure(request, response, tester.getTag(), tester.getPath(), "invalid-secondary-handle");
        }
    }
}

