/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.ObjectUtils;
import org.vxwo.springboot.experience.web.config.GroupPathRule;
import org.vxwo.springboot.experience.web.matcher.PathRuleMatcher;
import org.vxwo.springboot.experience.web.matcher.PathTester;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;
import org.vxwo.springboot.experience.web.util.SplitUtil;

public class GroupPathRuleMatcher
implements PathRuleMatcher {
    private final List<TagPathTester<ExcludesAndOptionals>> acceptPathTesters = new ArrayList<TagPathTester<ExcludesAndOptionals>>();

    public GroupPathRuleMatcher(String configName, List<GroupPathRule> pathRules) {
        if (ObjectUtils.isEmpty(pathRules)) {
            throw new RuntimeException(String.format("Configuration: {%s} empty", configName));
        }
        HashSet<String> excludeOrOptionalPathSet = new HashSet<String>();
        for (int i = 0; i < pathRules.size(); ++i) {
            boolean existOptionals;
            GroupPathRule pathRule = pathRules.get(i);
            String configPathName = String.format("%s.[%d]", configName, i);
            String path = pathRule.getPath();
            if (ObjectUtils.isEmpty((Object)path)) {
                throw new RuntimeException(String.format("Configuration: {%s.path} empty", configPathName));
            }
            if (PathTester.isPattern(path)) {
                throw new RuntimeException(String.format("Configuration: {%s.path} has pattern character", configPathName));
            }
            boolean existExcludes = !ObjectUtils.isEmpty(pathRule.getExcludes());
            boolean bl = existOptionals = !ObjectUtils.isEmpty(pathRule.getOptionals());
            if ((existExcludes || existOptionals) && !path.endsWith("/")) {
                throw new RuntimeException(String.format("Configuration: {%s.path} not ends with '/'", configPathName));
            }
            ArrayList<PathTester> excludePathTesters = new ArrayList<PathTester>();
            if (existExcludes) {
                for (String exclude : SplitUtil.shrinkList(pathRule.getExcludes())) {
                    if (exclude.startsWith("/")) {
                        throw new RuntimeException(String.format("Configuration: {%s.excludes} starts with '/'", configPathName));
                    }
                    if (PathTester.isPattern(exclude)) {
                        throw new RuntimeException(String.format("Configuration: {%s.excludes} has pattern character", configPathName));
                    }
                    String excludePath = path + exclude;
                    PathTester matcher = new PathTester(excludePath);
                    if (excludeOrOptionalPathSet.contains(excludePath)) continue;
                    excludePathTesters.add(matcher);
                    excludeOrOptionalPathSet.add(excludePath);
                }
            }
            ArrayList<PathTester> optionalPathTesters = new ArrayList<PathTester>();
            if (existOptionals) {
                for (String optional : SplitUtil.shrinkList(pathRule.getOptionals())) {
                    if (optional.startsWith("/")) {
                        throw new RuntimeException(String.format("Configuration: {%s.optionals} starts with '/'", configPathName));
                    }
                    if (PathTester.isPattern(optional)) {
                        throw new RuntimeException(String.format("Configuration: {%s.optionals} has pattern character", configPathName));
                    }
                    String optionalPath = path + optional;
                    PathTester matcher = new PathTester(optionalPath);
                    if (excludeOrOptionalPathSet.contains(optionalPath)) continue;
                    optionalPathTesters.add(matcher);
                    excludeOrOptionalPathSet.add(optionalPath);
                }
            }
            this.acceptPathTesters.add(new TagPathTester<ExcludesAndOptionals>(pathRule.getTag(), path, new ExcludesAndOptionals(Collections.unmodifiableList(excludePathTesters), Collections.unmodifiableList(optionalPathTesters))));
        }
    }

    public TagPathTester<ExcludesAndOptionals> findMatchTester(String path) {
        for (TagPathTester<ExcludesAndOptionals> tester : this.acceptPathTesters) {
            if (!tester.test(path)) continue;
            return tester;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.acceptPathTesters.size() + " paths");
        for (TagPathTester<ExcludesAndOptionals> tester : this.acceptPathTesters) {
            sb.append("\n tag: " + tester.getTag() + ", path: " + tester.toPathMatch());
            if (!ObjectUtils.isEmpty(tester.getExtra().getExcludes())) {
                sb.append("\n  excludes:\n" + String.join((CharSequence)"\n", tester.getExtra().getExcludes().stream().map(o -> "   " + o.toPathMatch()).collect(Collectors.toList())));
            }
            if (ObjectUtils.isEmpty(tester.getExtra().getOptionals())) continue;
            sb.append("\n  optionals:\n" + String.join((CharSequence)"\n", tester.getExtra().getOptionals().stream().map(o -> "   " + o.toPathMatch()).collect(Collectors.toList())));
        }
        return sb.toString();
    }

    @Override
    public List<String> getPathMatchs(String tag) {
        return this.acceptPathTesters.stream().filter(o -> o.getTag().equals(tag)).map(o -> o.toPathMatch()).collect(Collectors.toList());
    }

    @Override
    public List<String> getExcludePathMatchs(String tag) {
        ArrayList<String> pathMatches = new ArrayList<String>();
        this.acceptPathTesters.stream().filter(o -> o.getTag().equals(tag)).forEach(o -> {
            ((ExcludesAndOptionals)o.getExtra()).getExcludes().stream().forEach(x -> pathMatches.add(x.toPathMatch()));
            ((ExcludesAndOptionals)o.getExtra()).getOptionals().stream().forEach(x -> pathMatches.add(x.toPathMatch()));
        });
        return pathMatches;
    }

    public static class ExcludesAndOptionals {
        private List<PathTester> excludes;
        private List<PathTester> optionals;

        public boolean isExclude(String path) {
            for (PathTester s : this.excludes) {
                if (!s.test(path)) continue;
                return true;
            }
            return false;
        }

        public boolean isOptional(String path) {
            for (PathTester s : this.optionals) {
                if (!s.test(path)) continue;
                return true;
            }
            return false;
        }

        public List<PathTester> getExcludes() {
            return this.excludes;
        }

        public List<PathTester> getOptionals() {
            return this.optionals;
        }

        public ExcludesAndOptionals(List<PathTester> excludes, List<PathTester> optionals) {
            this.excludes = excludes;
            this.optionals = optionals;
        }
    }
}

