/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.ObjectUtils;
import org.vxwo.springboot.experience.web.config.OwnerPathRule;
import org.vxwo.springboot.experience.web.matcher.PathRuleMatcher;
import org.vxwo.springboot.experience.web.matcher.PathTester;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;

public class OwnerPathRuleMatcher
implements PathRuleMatcher {
    private final List<TagPathTester<Map<String, String>>> acceptPathTesters = new ArrayList<TagPathTester<Map<String, String>>>();

    public OwnerPathRuleMatcher(String configName, List<OwnerPathRule> pathRules) {
        if (ObjectUtils.isEmpty(pathRules)) {
            throw new RuntimeException(String.format("Configuration: {%s} empty", configName));
        }
        for (int i = 0; i < pathRules.size(); ++i) {
            OwnerPathRule pathRule = pathRules.get(i);
            String configPathName = String.format("%s.[%d]", configName, i);
            String path = pathRule.getPath();
            if (ObjectUtils.isEmpty((Object)path)) {
                throw new RuntimeException(String.format("Configuration: {%s.path} empty", configPathName));
            }
            if (PathTester.isPattern(path)) {
                throw new RuntimeException(String.format("Configuration: {%s.path} has pattern character", configPathName));
            }
            HashMap<String, String> acceptKeys = new HashMap<String, String>();
            for (OwnerPathRule.KeyOwner target : pathRule.getOwners()) {
                String key = target.getKey();
                if (ObjectUtils.isEmpty((Object)key)) continue;
                String owner = target.getOwner();
                if (ObjectUtils.isEmpty((Object)owner)) {
                    owner = "none";
                }
                acceptKeys.put(key, owner);
            }
            this.acceptPathTesters.add(new TagPathTester(pathRule.getTag(), path, Collections.unmodifiableMap(acceptKeys)));
        }
    }

    public TagPathTester<Map<String, String>> findMatchTester(String path) {
        for (TagPathTester<Map<String, String>> tester : this.acceptPathTesters) {
            if (!tester.test(path)) continue;
            return tester;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.acceptPathTesters.size() + " paths");
        for (TagPathTester<Map<String, String>> tester : this.acceptPathTesters) {
            sb.append("\n tag: " + tester.getTag() + ", path: " + tester.toPathMatch() + ", owners: " + String.join((CharSequence)",", tester.getExtra().values()));
        }
        return sb.toString();
    }

    @Override
    public List<String> getPathMatchs(String tag) {
        return this.acceptPathTesters.stream().filter(o -> o.getTag().equals(tag)).map(o -> o.toPathMatch()).collect(Collectors.toList());
    }

    @Override
    public List<String> getExcludePathMatchs(String tag) {
        throw new UnsupportedOperationException("Unimplemented method 'getExcludePathMatchs'");
    }
}

