/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.vxwo.springboot.experience.web.filter.ApiKeyAuthorizationFilter;
import org.vxwo.springboot.experience.web.filter.BearerAuthorizationFilter;
import org.vxwo.springboot.experience.web.matcher.TagPathTester;
import org.vxwo.springboot.experience.web.processor.PathProcessor;

public class PathDocumentHelper {
    @Autowired
    private PathProcessor pathProcessor;
    @Autowired(required=false)
    private ApiKeyAuthorizationFilter apikeyAuthorization;
    @Autowired(required=false)
    private BearerAuthorizationFilter bearerAuthorization;

    public List<String> absPathMatches(List<String> input) {
        return input.stream().map(o -> this.pathProcessor.createAbsoluteURI((String)o)).collect(Collectors.toList());
    }

    public List<String> getApiKeyPathMatchs(String tag) {
        ArrayList<String> pathMatches = new ArrayList<String>();
        if (this.apikeyAuthorization != null) {
            pathMatches.addAll(this.absPathMatches(this.apikeyAuthorization.getPathRuleMatcher().getPathMatchs(TagPathTester.fixTag(tag))));
        }
        return pathMatches;
    }

    public List<String> getBearerPathMatchs(String tag) {
        ArrayList<String> pathMatches = new ArrayList<String>();
        if (this.bearerAuthorization != null) {
            pathMatches.addAll(this.absPathMatches(this.bearerAuthorization.getPathRuleMatcher().getPathMatchs(TagPathTester.fixTag(tag))));
        }
        return pathMatches;
    }

    public List<String> getBearerExcludePathMatchs(String tag) {
        ArrayList<String> pathMatches = new ArrayList<String>();
        if (this.bearerAuthorization != null) {
            pathMatches.addAll(this.absPathMatches(this.bearerAuthorization.getPathRuleMatcher().getExcludePathMatchs(TagPathTester.fixTag(tag))));
        }
        return pathMatches;
    }
}

