/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.processor;

import java.net.URI;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class PathProcessor {
    private static final Logger log = LoggerFactory.getLogger(PathProcessor.class);
    private static final String FAKE_HOST = "http://localhost";
    private static final int FAKE_LENGTH = "http://localhost".length();
    private static final String ATTRIBUTE_NAME = "SBEXP:" + UUID.randomUUID().toString() + ":RelativeURI";
    private String servletContextPath;
    private int servletContextPathLength = 0;

    @Autowired
    private void setServletContextPath(@Value(value="${server.servlet.context-path:/}") String contextPath) {
        this.servletContextPath = contextPath.replaceAll("\\/$", "");
        this.servletContextPathLength = this.servletContextPath.length();
        if (log.isInfoEnabled()) {
            log.info("Path processor actived on: " + this.servletContextPath + "/");
        }
    }

    public String createAbsoluteURI(String relativeURI) {
        return this.servletContextPath + relativeURI;
    }

    public String getRelativeURI(HttpServletRequest request) {
        String targetURI = (String)request.getAttribute(ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)targetURI)) {
            return targetURI;
        }
        targetURI = request.getRequestURI();
        try {
            targetURI = URI.create(FAKE_HOST + targetURI).normalize().toString().substring(FAKE_LENGTH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (targetURI.length() > this.servletContextPathLength) {
            targetURI = targetURI.substring(this.servletContextPathLength);
        }
        request.setAttribute(ATTRIBUTE_NAME, (Object)targetURI);
        return targetURI;
    }
}

