/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.processor;

import javax.servlet.http.HttpServletRequest;
import org.vxwo.springboot.experience.util.ExceptionUtils;
import org.vxwo.springboot.experience.web.config.RequestLoggingProperties;
import org.vxwo.springboot.experience.web.entity.RequestLoggingEntity;
import org.vxwo.springboot.experience.web.util.RequestUtil;

public class RequestLoggingHelper {
    private static final ThreadLocal<RequestLoggingEntity> LOCAL_ENTITY = new ThreadLocal();
    private final int stacktraceLimitLines;

    public RequestLoggingHelper(RequestLoggingProperties value) {
        this.stacktraceLimitLines = value.getStacktraceLimitLines();
    }

    private RequestLoggingEntity getLoggingEntity() {
        HttpServletRequest request = RequestUtil.tryGetRequest();
        if (request != null) {
            return (RequestLoggingEntity)request.getAttribute(RequestLoggingEntity.ATTRIBUTE_NAME);
        }
        return LOCAL_ENTITY.get();
    }

    public void putOwner(String owner) {
        RequestLoggingEntity entity = this.getLoggingEntity();
        if (entity == null) {
            return;
        }
        entity.setOwner(owner);
    }

    public void putCustomDetail(String key, Object detail) {
        RequestLoggingEntity entity = this.getLoggingEntity();
        if (entity == null) {
            return;
        }
        entity.getCustomDetails().put(key, detail);
    }

    public void putCustomDetail(String key, Exception exception) {
        RequestLoggingEntity entity = this.getLoggingEntity();
        if (entity == null) {
            return;
        }
        entity.getCustomDetails().put(key, ExceptionUtils.getStackTrace((Throwable)exception, (int)this.stacktraceLimitLines));
    }

    public RequestLoggingEntity createLocalEntity() {
        LOCAL_ENTITY.remove();
        RequestLoggingEntity entity = new RequestLoggingEntity();
        LOCAL_ENTITY.set(entity);
        return entity;
    }

    public void removeLocalEntity() {
        LOCAL_ENTITY.remove();
    }
}

