/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class RequestUtil {
    private static final String LOCALVALUES_ATTRIBUTE = "SBEXP:" + UUID.randomUUID().toString() + ":LocalValues";

    public static HttpServletRequest tryGetRequest() {
        HttpServletRequest request = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            request = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return request;
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = RequestUtil.tryGetRequest();
        if (request == null) {
            throw new UnsupportedOperationException();
        }
        return request;
    }

    public static Map<String, Object> getLocalValues() {
        HttpServletRequest request = RequestUtil.getRequest();
        HashMap values = (HashMap)request.getAttribute(LOCALVALUES_ATTRIBUTE);
        if (values == null) {
            values = new HashMap(10);
            request.setAttribute(LOCALVALUES_ATTRIBUTE, values);
        }
        return values;
    }

    public static Object getLocalValue(String key) {
        return RequestUtil.getLocalValues().get(key);
    }

    public static void putLocalValue(String key, Object value) {
        RequestUtil.getLocalValues().put(key, value);
    }
}

