/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.vxwo.springboot.experience.web.validation.MultiChoices;

public class MultiChoicesValidator
implements ConstraintValidator<MultiChoices, String> {
    private List<String> allowValues;
    private String split;
    private boolean alloweEmpty;

    public void initialize(MultiChoices annotation) {
        this.allowValues = Arrays.asList(annotation.values());
        this.split = String.valueOf(annotation.splitChar());
        this.alloweEmpty = annotation.allowEmpty();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return this.alloweEmpty;
        }
        boolean passed = true;
        ArrayList<String> unique = new ArrayList<String>();
        for (String s : value.split(this.split)) {
            boolean bl = passed = this.allowValues.contains(s) && !unique.contains(s);
            if (!passed) break;
            unique.add(s);
        }
        return passed;
    }
}

