/*
 * Decompiled with CFR 0.152.
 */
package org.vxwo.springboot.experience.web.validation;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.vxwo.springboot.experience.web.validation.MultiPattern;

public class MultiPatternValidator
implements ConstraintValidator<MultiPattern, String> {
    private Pattern pattern;
    private Pattern reservePattern;
    private String splitChar;
    private boolean alloweEmpty;

    public void initialize(MultiPattern annotation) {
        this.pattern = Pattern.compile(annotation.value());
        if (annotation.reserveValue() != null && !annotation.reserveValue().isEmpty()) {
            this.reservePattern = Pattern.compile(annotation.reserveValue());
        }
        this.splitChar = String.valueOf(annotation.splitChar());
        this.alloweEmpty = annotation.allowEmpty();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return this.alloweEmpty;
        }
        boolean passed = true;
        ArrayList<String> unique = new ArrayList<String>();
        for (String s : value.split(this.splitChar)) {
            boolean bl = passed = this.pattern.matcher(s).matches() && !unique.contains(s);
            if (!passed) break;
            unique.add(s);
        }
        if (!passed && this.reservePattern != null) {
            passed = this.reservePattern.matcher(value).matches();
        }
        return passed;
    }
}

