/*
 * Decompiled with CFR 0.152.
 */
package org.wabase.spreadsheet.xlsxml;

import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import org.wabase.Format$;
import org.wabase.spreadsheet.xlsxml.DATE_TIME$;
import org.wabase.spreadsheet.xlsxml.DataType;
import org.wabase.spreadsheet.xlsxml.NUMBER$;
import org.wabase.spreadsheet.xlsxml.STRING$;
import org.wabase.spreadsheet.xlsxml.Style;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000554AAD\b\u00011!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003\"\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\u0019\u0006\u0001\"\u0001S\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u001di\u0006!%A\u0005\u0002yCQ!\u001b\u0001\u0005\u0002ICQA\u001b\u0001\u0005\u0002ICQa\u001b\u0001\u0005\u0002ICQ\u0001\u001c\u0001\u0005\u0002I\u0013a\u0002\u00177t16d7\u000b\u001e:fC6,'O\u0003\u0002\u0011#\u00051\u0001\u0010\\:y[2T!AE\n\u0002\u0017M\u0004(/Z1eg\",W\r\u001e\u0006\u0003)U\taa^1cCN,'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-A\u0002pkR,\u0012!\t\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\n!![8\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007/JLG/\u001a:\u0002\t=,H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051r\u0003CA\u0017\u0001\u001b\u0005y\u0001\"B\u0010\u0004\u0001\u0004\t\u0013!D:uCJ$xk\u001c:lE>|7\u000e\u0006\u00022iA\u0011!DM\u0005\u0003gm\u0011A!\u00168ji\")Q\u0007\u0002a\u0001m\u000511\u000f^=mKN\u00042aN C\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002</\u00051AH]8pizJ\u0011\u0001H\u0005\u0003}m\tq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\n\u00191+Z9\u000b\u0005yZ\u0002CA\u0017D\u0013\t!uBA\u0003TifdW-\u0001\bti\u0006\u0014HoV8sWNDW-\u001a;\u0015\u0005E:\u0005\"\u0002%\u0006\u0001\u0004I\u0015\u0001\u00028b[\u0016\u0004\"A\u0013(\u000f\u0005-c\u0005CA\u001d\u001c\u0013\ti5$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'\u001c\u0003)\u0019H/\u0019:u)\u0006\u0014G.Z\u000b\u0002c\u0005A1\u000f^1siJ{w/\u0001\u0003dK2dGcA\u0019W7\")q\u000b\u0003a\u00011\u0006)a/\u00197vKB\u0011!$W\u0005\u00035n\u00111!\u00118z\u0011\u001da\u0006\u0002%AA\u0002\t\u000bQa\u001d;zY\u0016\fabY3mY\u0012\"WMZ1vYR$#'F\u0001`U\t\u0011\u0005mK\u0001b!\t\u0011w-D\u0001d\u0015\t!W-A\u0005v]\u000eDWmY6fI*\u0011amG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00015d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0007K:$'k\\<\u0002\u0011\u0015tG\rV1cY\u0016\fA\"\u001a8e/>\u00148n\u001d5fKR\f1\"\u001a8e/>\u00148NY8pW\u0002")
public class XlsXmlStreamer {
    private final Writer out;

    public Writer out() {
        return this.out;
    }

    public void startWorkbook(Seq<Style> styles) {
        block0: {
            this.out().write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("  |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n                   |<?mso-application progid=\"Excel.Sheet\"?>\n                   |<Workbook xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n                   |          xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\">\n                   |")));
            if (styles == null || styles.isEmpty()) break block0;
            this.out().write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|  <Styles>\n                   |")));
            styles.foreach((Function1 & Serializable)x$1 -> {
                x$1.write(this.out());
                return BoxedUnit.UNIT;
            });
            this.out().write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|  </Styles>\n                   |")));
        }
    }

    public void startWorksheet(String name) {
        this.out().write("  <Worksheet ss:Name=\"");
        this.out().write(name);
        this.out().write("\">\r\n");
    }

    public void startTable() {
        this.out().write("    <Table>\r\n");
    }

    public void startRow() {
        this.out().write("      <Row>");
    }

    public void cell(Object value, Style style) {
        DataType t = null;
        String v = null;
        Object object = value;
        if (object == null) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Number) {
            Number number = (Number)object;
            t = NUMBER$.MODULE$;
            v = number.toString();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            t = DATE_TIME$.MODULE$;
            v = new StringBuilder(13).append(Format$.MODULE$.xsdDate().apply(date)).append("T00:00:00.000").toString();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            t = STRING$.MODULE$;
            v = Format$.MODULE$.xmlEscape(object.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.out().write("<Cell");
        if (style != null) {
            this.out().write(" ss:StyleID=\"");
            this.out().write(style.id());
            this.out().write("\"");
        }
        this.out().write(">");
        if (v != null && v.length() > 0) {
            this.out().write("<Data ss:Type=\"");
            this.out().write(t.name());
            this.out().write("\">");
            this.out().write(v);
            this.out().write("</Data>");
        }
        this.out().write("</Cell>");
    }

    public Style cell$default$2() {
        return null;
    }

    public void endRow() {
        this.out().write("</Row>\r\n");
    }

    public void endTable() {
        this.out().write("    </Table>\r\n");
    }

    public void endWorksheet() {
        this.out().write("  </Worksheet>\r\n");
    }

    public void endWorkbook() {
        this.out().write("</Workbook>\r\n");
    }

    public XlsXmlStreamer(Writer out) {
        this.out = out;
    }
}

